/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bonemealCoral;

import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseCoralPlantTypeBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.CoralClawFeature;
import net.minecraft.world.level.levelgen.feature.CoralMushroomFeature;
import net.minecraft.world.level.levelgen.feature.CoralTreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.MapColor;
import org.spongepowered.asm.mixin.Mixin;
import xyz.faewulf.diversity.inter.ICustomBonemealable;
import xyz.faewulf.diversity.mixin.general.bonemealCoral.CoralFeatureInvoker;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;

@Mixin(value={CoralPlantBlock.class})
public class CoralMixin
implements ICustomBonemealable {
    @Override
    public boolean Diversity$isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (!ModConfigs.bonemeal_coral_fan) {
            return false;
        }
        Holder currentBiome = level.getBiome(pos);
        return !Compare.isHasTag((Block)state.getBlock(), (String)"diversity:bonemeal_blacklist") && (Boolean)state.getValue((Property)BaseCoralPlantTypeBlock.WATERLOGGED) != false && level.getFluidState(pos.above()).is(FluidTags.WATER) && currentBiome.is(BiomeTags.PRODUCES_CORALS_FROM_BONEMEAL);
    }

    @Override
    public boolean Diversity$isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return (double)level.random.nextFloat() < 0.12;
    }

    @Override
    public void Diversity$performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        Holder coral_block;
        CoralTreeFeature coral = switch (level.random.nextInt(3)) {
            case 0 -> new CoralTreeFeature(NoneFeatureConfiguration.CODEC);
            case 1 -> new CoralClawFeature(NoneFeatureConfiguration.CODEC);
            default -> new CoralMushroomFeature(NoneFeatureConfiguration.CODEC);
        };
        MapColor color = state.getMapColor((BlockGetter)level, pos);
        BlockState coralBlockMatchedColor = state;
        Optional coralBlocksRegistry = level.registryAccess().lookupOrThrow(Registries.BLOCK).get(BlockTags.CORAL_BLOCKS);
        if (!coralBlocksRegistry.isPresent()) {
            return;
        }
        HolderSet.Named coralBlocks = (HolderSet.Named)coralBlocksRegistry.get();
        Iterator iterator = coralBlocks.iterator();
        while (iterator.hasNext() && (coralBlockMatchedColor = ((Block)(coral_block = (Holder)iterator.next()).value()).defaultBlockState()).getMapColor((BlockGetter)level, pos) != color) {
        }
        level.setBlock(pos, Blocks.WATER.defaultBlockState(), 260);
        if (!((CoralFeatureInvoker)coral).generateCoral((LevelAccessor)level, level.random, pos, coralBlockMatchedColor)) {
            level.setBlock(pos, state, 3);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 7, 0.3, 0.3, 0.3, 0.1);
        }
    }
}

