/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.xpCrops;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={Block.class})
public abstract class BlockMixin
extends BlockBehaviour
implements ItemLike {
    public BlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"dropResources(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/entity/BlockEntity;)V"}, at={@At(value="HEAD")})
    private static void popResourceInject(BlockState state, LevelAccessor level, BlockPos pos, BlockEntity blockEntity, CallbackInfo ci) {
        if (!ModConfigs.xp_crops) {
            return;
        }
        if (level instanceof ServerLevel) {
            CropBlock cropBlock;
            ServerLevel serverWorld = (ServerLevel)level;
            Block block = state.getBlock();
            if (block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(state)) {
                ExperienceOrb.award((ServerLevel)serverWorld, (Vec3)pos.getCenter(), (int)serverWorld.random.nextIntBetweenInclusive(0, 1));
            }
        }
    }
}

