/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bannerTrophy;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.CustomBanner;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={EndDragonFight.class})
public class EnderDragonFightMixin {
    @Shadow
    @Final
    private ServerLevel level;
    @Shadow
    @Final
    private BlockPos origin;

    @Inject(method={"setDragonKilled"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")})
    private void dragonKilledInject1(EnderDragon dragon, CallbackInfo ci) {
        if (!ModConfigs.banner_trohpy) {
            return;
        }
        Vec3 pos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.getLocation((BlockPos)this.origin)).getCenter();
        ItemStack eggTrophy = CustomBanner.enderEggBanner((HolderGetter<BannerPattern>)dragon.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN));
        eggTrophy.setCount(1);
        ItemEntity itemEntity = new ItemEntity((Level)this.level, pos.x(), pos.y() + 1.0, pos.z(), eggTrophy);
        itemEntity.setDeltaMovement(Vec3.ZERO);
        this.level.addFreshEntity((Entity)itemEntity);
    }

    @Inject(method={"setDragonKilled"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/dimension/end/EndDragonFight;spawnNewGateway()V")})
    private void dragonKilledInject2(EnderDragon dragon, CallbackInfo ci) {
        if (!ModConfigs.banner_trohpy) {
            return;
        }
        Vec3 pos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, EndPodiumFeature.getLocation((BlockPos)this.origin)).getCenter();
        ItemStack eggTrophy = CustomBanner.enderDragonBanner((HolderGetter<BannerPattern>)dragon.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN));
        eggTrophy.setCount(1);
        ItemEntity itemEntity = new ItemEntity((Level)this.level, pos.x(), pos.y() + 1.0, pos.z(), eggTrophy);
        itemEntity.setDeltaMovement(Vec3.ZERO);
        this.level.addFreshEntity((Entity)itemEntity);
    }
}

