/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.shearPickpocketVillager;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.util.CustomLootTables;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.entity.EntityUtils;

@Mixin(value={Villager.class})
public abstract class villagerMixin
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder {
    @Unique
    private int Diversity$pickpocket_cooldown = 0;

    @Shadow
    public abstract VillagerData getVillagerData();

    @Shadow
    public abstract void handleEntityEvent(byte var1);

    @Shadow
    public abstract Brain<Villager> getBrain();

    @Shadow
    public abstract void setVillagerData(VillagerData var1);

    public villagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void tickInject(CallbackInfo ci) {
        if (!this.isClientSide() && ModConfigs.shear_can_pickpocket_villager && this.Diversity$pickpocket_cooldown > 0) {
            --this.Diversity$pickpocket_cooldown;
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteractInject(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (!ModConfigs.shear_can_pickpocket_villager || this.level().isClientSide) {
            return;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isShiftKeyDown() && Compare.isHasTag((Item)itemStack.getItem(), (String)"diversity:pickpocket_tool") && this.Diversity$pickpocket_cooldown <= 0) {
            String job = this.getVillagerData().getProfession().name();
            int jobLevel = this.getVillagerData().getLevel();
            Vec3 blockPos = this.blockPosition().getCenter();
            this.dropFromGiftLootTable((ServerLevel)this.level(), villagerMixin.diversity_Multiloader$getPickPocketLootTable(job), (level, itemStack1) -> {
                ItemEntity itementity = new ItemEntity(this.level(), blockPos.x, blockPos.y, blockPos.z, itemStack1);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            });
            boolean sneaky = EntityUtils.isEntity2BehindEntity1((LivingEntity)this, (LivingEntity)player);
            boolean stealth = !this.hasLineOfSight((Entity)player) || player.hasEffect(MobEffects.INVISIBILITY);
            float successChance = 0.3f;
            if (sneaky) {
                successChance = 0.7f;
            }
            if (stealth) {
                successChance = 1.0f;
            }
            if (this.random.nextFloat() > successChance) {
                this.hurtServer((ServerLevel)this.level(), this.damageSources().playerAttack(player), 0.0f);
            }
            if (jobLevel == 1) {
                this.Diversity$pickpocket_cooldown = 6000;
            }
            if (jobLevel > 1 && this.random.nextFloat() > (float)jobLevel * 0.15f) {
                VillagerData old = this.getVillagerData();
                this.setVillagerData(new VillagerData(old.getType(), VillagerProfession.NONE, 1));
                ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, this.getX(), this.getY(), this.getZ(), 1, 0.0, 0.0, 0.0, 0.5);
                this.Diversity$pickpocket_cooldown = 6000;
            }
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, villagerMixin.getSlotForHand((InteractionHand)hand));
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
        if (player.isShiftKeyDown() && Compare.isHasTag((Item)itemStack.getItem(), (String)"diversity:pickpocket_tool") && this.Diversity$pickpocket_cooldown > 0) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), 20, (double)0.2f, (double)0.2f, (double)0.2f, (double)0.02f);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            cir.cancel();
        }
    }

    @Unique
    private boolean diversity$isEntity2BehindEntity1(LivingEntity entity1, LivingEntity entity2) {
        Vec3 toEntity2;
        Vec3 entity1ViewVector = entity1.getViewVector(1.0f);
        double dotProduct = entity1ViewVector.dot(toEntity2 = entity2.position().subtract(entity1.position()).normalize());
        double angle = Math.acos(dotProduct);
        return angle >= 1.5707963267948966 && angle <= Math.PI;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveDataInject(CompoundTag compound, CallbackInfo ci) {
        compound.putInt("diversity:pickpocket_cooldown", this.Diversity$pickpocket_cooldown);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveDataInject(CompoundTag compound, CallbackInfo ci) {
        if (compound.contains("diversity:pickpocket_cooldown", 3)) {
            this.Diversity$pickpocket_cooldown = compound.getInt("diversity:pickpocket_cooldown");
        }
    }

    @Unique
    private static ResourceKey<LootTable> diversity_Multiloader$getPickPocketLootTable(String name) {
        switch (name) {
            case "armorer": {
                return CustomLootTables.PICKPOCKET_ARMORER;
            }
            case "butcher": {
                return CustomLootTables.PICKPOCKET_BUTCHER;
            }
            case "cartographer": {
                return CustomLootTables.PICKPOCKET_CARTOGRAPHER;
            }
            case "cleric": {
                return CustomLootTables.PICKPOCKET_CLERIC;
            }
            case "farmer": {
                return CustomLootTables.PICKPOCKET_FARMER;
            }
            case "fisherman": {
                return CustomLootTables.PICKPOCKET_FISHERMAN;
            }
            case "fletcher": {
                return CustomLootTables.PICKPOCKET_FLETCHER;
            }
            case "leatherworker": {
                return CustomLootTables.PICKPOCKET_LEATHERWORKER;
            }
            case "librarian": {
                return CustomLootTables.PICKPOCKET_LIBRARIAN;
            }
            case "mason": {
                return CustomLootTables.PICKPOCKET_MASON;
            }
            case "nitwit": {
                return CustomLootTables.PICKPOCKET_NITWIT;
            }
            case "shepherd": {
                return CustomLootTables.PICKPOCKET_SHEPHERD;
            }
            case "toolsmith": {
                return CustomLootTables.PICKPOCKET_TOOLSMITH;
            }
            case "weaponsmith": {
                return CustomLootTables.PICKPOCKET_WEAPONSMITH;
            }
        }
        return CustomLootTables.PICKPOCKET_NONE;
    }
}

