/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util.gameTests.entry.general;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.gameTests.TestGroup;

@TestGroup
public class trophyBanner {
    @GameTest(template="faewulf_lib:default")
    public void trophyBanner_Wither(GameTestHelper helper) {
        if (!ModConfigs.banner_trohpy) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        BlockPos pos = new BlockPos(4, 2, 4);
        Mob target = helper.spawnWithNoFreeWill(EntityType.WITHER, pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.attack((Entity)target);
        helper.kill((Entity)target);
        List items = helper.getEntities(EntityType.ITEM, pos, 4.0);
        helper.runAfterDelay(40L, () -> {
            for (ItemEntity item : items) {
                if (!Compare.isHasTag((Item)item.getItem().getItem(), (String)"minecraft:banners")) continue;
                helper.succeed();
                return;
            }
            helper.fail("No banner drop");
        });
    }

    @GameTest(template="faewulf_lib:default")
    public void trophyBanner_Warden(GameTestHelper helper) {
        if (!ModConfigs.banner_trohpy) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        BlockPos pos = new BlockPos(4, 2, 4);
        Mob target = helper.spawnWithNoFreeWill(EntityType.WARDEN, pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.attack((Entity)target);
        helper.kill((Entity)target);
        List items = helper.getEntities(EntityType.ITEM, pos, 4.0);
        helper.runAfterDelay(40L, () -> {
            for (ItemEntity item : items) {
                if (!Compare.isHasTag((Item)item.getItem().getItem(), (String)"minecraft:banners")) continue;
                helper.succeed();
                return;
            }
            helper.fail("No banner drop");
        });
    }

    @GameTest(template="faewulf_lib:default")
    public void trophyBanner_EnderDragon(GameTestHelper helper) {
        if (!ModConfigs.banner_trohpy) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        BlockPos pos = new BlockPos(4, 2, 4);
        Mob target = helper.spawnWithNoFreeWill(EntityType.ENDER_DRAGON, pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.attack((Entity)target);
        helper.kill((Entity)target);
        List items = helper.getEntities(EntityType.ITEM, pos, 4.0);
        helper.runAfterDelay(40L, () -> {
            for (ItemEntity item : items) {
                if (!Compare.isHasTag((Item)item.getItem().getItem(), (String)"minecraft:banners")) continue;
                helper.succeed();
                return;
            }
            helper.fail("No banner drop");
        });
    }

    @GameTest(template="faewulf_lib:default")
    public void trophyBanner_ElderGuardian(GameTestHelper helper) {
        if (!ModConfigs.banner_trohpy) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        BlockPos pos = new BlockPos(4, 2, 4);
        Mob target = helper.spawnWithNoFreeWill(EntityType.ELDER_GUARDIAN, pos);
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        player.attack((Entity)target);
        helper.kill((Entity)target);
        List items = helper.getEntities(EntityType.ITEM, pos, 4.0);
        helper.runAfterDelay(40L, () -> {
            for (ItemEntity item : items) {
                if (!Compare.isHasTag((Item)item.getItem().getItem(), (String)"minecraft:banners")) continue;
                helper.succeed();
                return;
            }
            helper.fail("No banner drop");
        });
    }
}

