/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.platform.services;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public interface IPlatformHelper {
    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    default public List<Class<?>> findClasses(String scannedPackage) {
        String scannedPath = scannedPackage.replace('.', '/');
        URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
        if (scannedUrl == null) {
            throw new IllegalArgumentException(String.format("Unable to get resources from path '%s'. Are you sure the package '%s' exists?", scannedPath, scannedPackage));
        }
        File scannedDir = new File(scannedUrl.getFile());
        ArrayList classes = new ArrayList();
        try {
            for (File file : Objects.requireNonNull(scannedDir.listFiles())) {
                classes.addAll(IPlatformHelper.find(file, scannedPackage));
            }
        }
        catch (NullPointerException e) {
            return classes;
        }
        return classes;
    }

    private static List<Class<?>> find(File file, String scannedPackage) {
        ArrayList classes = new ArrayList();
        String resource = scannedPackage + "." + file.getName();
        if (file.isDirectory()) {
            try {
                for (File child : Objects.requireNonNull(file.listFiles())) {
                    classes.addAll(IPlatformHelper.find(child, resource));
                }
            }
            catch (NullPointerException e) {
                return classes;
            }
        }
        if (resource.endsWith(".class")) {
            int endIndex = resource.length() - ".class".length();
            String className = resource.substring(0, endIndex);
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return classes;
    }
}

