/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.clickThrough;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.BlockEntityContainer;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={ServerPlayer.class})
public abstract class WallSign
extends Player {
    public WallSign(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"openTextEdit"}, at={@At(value="HEAD")}, cancellable=true)
    private void openEditSignScreenMixin(SignBlockEntity sign, boolean front, CallbackInfo ci) {
        if (!ModConfigs.click_through_itemframe) {
            return;
        }
        if (this.isShiftKeyDown()) {
            return;
        }
        Block block = sign.getBlockState().getBlock();
        if (block instanceof WallSignBlock) {
            WallSignBlock wallSignBlock = (WallSignBlock)block;
            BlockPos posBehindItemFrame = sign.getBlockPos().relative(((Direction)sign.getBlockState().getValue((Property)WallSignBlock.FACING)).getOpposite(), 1);
            boolean success = BlockEntityContainer.tryOpenContainer(posBehindItemFrame, this);
            if (success) {
                ci.cancel();
            }
        }
    }
}

