/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.invisibleItemFrame;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.inter.ICustomItemFrame;

@Mixin(value={BlockAttachedEntity.class})
public class InvisibleItemFrameIndicator {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        BlockAttachedEntity _this = (BlockAttachedEntity)this;
        if (_this.getType() == EntityType.ITEM_FRAME || _this.getType() == EntityType.GLOW_ITEM_FRAME) {
            if (_this.level().isClientSide) {
                return;
            }
            if (!((ICustomItemFrame)_this).diversity_Multiloader$getIsInvisible()) {
                return;
            }
            if (!((ItemFrame)_this).getItem().isEmpty()) {
                return;
            }
            RandomSource random = RandomSource.create();
            Direction direction = _this.getNearestViewDirection();
            BlockPos pos = _this.blockPosition();
            double d = (double)pos.getX() - (double)direction.getStepX() / 2.0 + 0.5 + 0.1 * (double)direction.getStepX();
            double e = (double)pos.getY() - (double)direction.getStepY() / 2.0 + 0.5 + 0.1 * (double)direction.getStepY();
            double f = (double)pos.getZ() - (double)direction.getStepZ() / 2.0 + 0.5 + 0.1 * (double)direction.getStepZ();
            double g = 0.25f - random.nextFloat() * 0.5f;
            if (direction.getStepX() == 0) {
                d += random.nextInt(2) == 0 ? g : -g;
            }
            if (direction.getStepY() == 0) {
                e += random.nextInt(2) == 0 ? g : -g;
            }
            if (direction.getStepZ() == 0) {
                f += random.nextInt(2) == 0 ? g : -g;
            }
            if (random.nextInt(40) == 10) {
                ((ServerLevel)_this.level()).sendParticles((ParticleOptions)ParticleTypes.WAX_OFF, d, e, f, 1, random.nextGaussian() * 0.005, random.nextGaussian() * 0.005, random.nextGaussian() * 0.005, 0.001);
            }
        }
    }
}

