/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.feature.entity.pseudoBlockEntity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import xyz.faewulf.diversity.feature.entity.pseudoBlockEntity.PseudoBlockEntityBuilder;

public class PseudoBlockEntities {
    public static Map<String, PseudoBlockEntityBuilder> PseudoBlockEntityList = new HashMap<String, PseudoBlockEntityBuilder>();
    public static PseudoBlockEntityBuilder STOP_GROW = PseudoBlockEntities.register("stop_grow", new PseudoBlockEntityBuilder().setParent(Blocks.SUGAR_CANE, Blocks.BAMBOO_SAPLING, Blocks.BAMBOO).setParentTag("minecraft:saplings", "diversity:trimmable").setDiscardWhenFunction(t -> {
        BlockState blockStateAbove = t.level().getBlockState(t.blockPosition().above());
        BlockState blockStateThis = t.level().getBlockState(t.blockPosition());
        if (blockStateThis.getBlock() == Blocks.VINE) {
            return false;
        }
        return blockStateAbove.getBlock() != Blocks.AIR;
    }));
    public static PseudoBlockEntityBuilder WET_SPONGE = PseudoBlockEntities.register("wet_sponge", new PseudoBlockEntityBuilder().setParent(Blocks.WET_SPONGE).setTickDelay(10).setBlockTickFunction(t -> {
        BlockPos pos;
        ServerLevel world = (ServerLevel)t.level();
        if (((Biome)world.getBiome(pos = t.blockPosition()).value()).getBaseTemperature() > 1.0f) {
            if (world.random.nextInt(20) == 2) {
                world.setBlock(pos, Blocks.SPONGE.defaultBlockState(), 3);
                world.levelEvent(2009, pos, 0);
                world.playSound(null, pos, SoundEvents.WET_SPONGE_DRIES, SoundSource.BLOCKS, 1.0f, (1.0f + world.getRandom().nextFloat() * 0.2f) * 0.7f);
                t.discard();
            } else {
                Vec3 center = pos.getCenter();
                world.sendParticles((ParticleOptions)ParticleTypes.CLOUD, center.x, center.y + 0.6, center.z, 3, 0.3, 0.0, 0.3, 0.0);
            }
        } else {
            t.discard();
        }
    }));

    public static PseudoBlockEntityBuilder register(String name, PseudoBlockEntityBuilder pseudoBlockEntity) {
        PseudoBlockEntityList.put(name, pseudoBlockEntity.setBlockEntityType(name));
        return pseudoBlockEntity;
    }
}

