/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bundleEnchantments;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.compat.MetalBundles.MetalBundleItemInvoker;
import xyz.faewulf.diversity.inter.ICustomBundleVacuum;
import xyz.faewulf.diversity.platform.Services;
import xyz.faewulf.diversity.util.Utils;
import xyz.faewulf.lib.util.EnchantHelper;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity
implements TraceableEntity {
    @Shadow
    private int pickupDelay;
    @Shadow
    @Nullable
    private UUID target;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Unique
    private static int diversity_Multiloader$getMaxSize(Level level, ItemStack itemStack) {
        int originalSize = 64;
        if (Services.PLATFORM.isModLoaded("metalbundles")) {
            Fraction a = MetalBundleItemInvoker.getActualWeightInvoker(itemStack);
            int usedSpace = Mth.mulAndTruncate((Fraction)((BundleContents)itemStack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).weight(), (int)64);
            originalSize = Utils.recoverCapacity(a, usedSpace);
        }
        int value = EnchantHelper.getEnchantLevelFromItem((Level)level, (ItemStack)itemStack, (String)"diversity", (String)"capacity");
        return originalSize + value * 64;
    }

    @Inject(method={"playerTouch"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;getCount()I")}, cancellable=true)
    private void playerTouchInject(Player entity, CallbackInfo ci, @Local(ordinal=0) ItemStack itemstack) {
        if (this.pickupDelay != 0 || this.target != null && !this.target.equals(entity.getUUID())) {
            return;
        }
        if (itemstack.getMaxStackSize() <= 1 || itemstack.isEmpty()) {
            return;
        }
        ArrayList<ItemStack> bundles = new ArrayList<ItemStack>();
        int originalCount = itemstack.getCount();
        for (int index = 0; index < entity.getInventory().getContainerSize(); ++index) {
            int value2;
            int value1;
            ItemStack item = entity.getInventory().getItem(index);
            if (item.isEmpty() || (value1 = EnchantHelper.getEnchantLevelFromItem((Level)this.level(), (ItemStack)item, (String)"diversity", (String)"vacuum")) + (value2 = EnchantHelper.getEnchantLevelFromItem((Level)this.level(), (ItemStack)item, (String)"diversity", (String)"selective_vacuum")) <= 0 || !(item.getItem() instanceof ICustomBundleVacuum)) continue;
            if (value2 > 0) {
                bundles.addFirst(item);
                continue;
            }
            bundles.add(item);
        }
        for (ItemStack bundle : bundles) {
            int freeSlotInBundle;
            int numberOfItemWillPut;
            int maxBundleSize;
            Object value2;
            if (ci.isCancelled()) break;
            if (bundle == null || !((value2 = bundle.get(DataComponents.BUNDLE_CONTENTS)) instanceof BundleContents)) continue;
            BundleContents bundleContentsComponent = (BundleContents)value2;
            boolean isSelective = false;
            if (EnchantHelper.hasEnchantment((Level)this.level(), (ItemStack)bundle, (String)"diversity", (String)"selective_vacuum")) {
                isSelective = true;
            }
            int stackMultiplier = 64 / itemstack.getMaxStackSize();
            int realStackSizeOfTheItemWillPutInto = stackMultiplier * itemstack.getCount();
            int usedSlotInBundle = Mth.mulAndTruncate((Fraction)bundleContentsComponent.weight(), (int)64);
            if (usedSlotInBundle >= (maxBundleSize = ItemEntityMixin.diversity_Multiloader$getMaxSize(this.level(), bundle)) || (numberOfItemWillPut = (int)Math.floor((float)Math.min(freeSlotInBundle = maxBundleSize - usedSlotInBundle, realStackSizeOfTheItemWillPutInto) * 1.0f / (float)stackMultiplier)) <= 0) continue;
            ArrayList itemStacksInBundle = new ArrayList(bundleContentsComponent.itemCopyStream().toList());
            boolean hasInsert = false;
            for (ItemStack itemStackInBundle : itemStacksInBundle) {
                int maxSize;
                if (!ItemStack.isSameItemSameComponents((ItemStack)itemStackInBundle, (ItemStack)itemstack) || itemStackInBundle.getCount() >= itemStackInBundle.getMaxStackSize()) continue;
                int countInBundle = itemStackInBundle.getCount();
                if (countInBundle + numberOfItemWillPut > (maxSize = itemStackInBundle.getMaxStackSize())) {
                    ItemStack newItemStack;
                    int slotLeft = maxSize - countInBundle;
                    int numberOfItemWillPutIntoCurrentBundle = numberOfItemWillPut;
                    numberOfItemWillPutIntoCurrentBundle -= slotLeft;
                    itemStackInBundle.grow(slotLeft);
                    while (numberOfItemWillPutIntoCurrentBundle > maxSize) {
                        numberOfItemWillPutIntoCurrentBundle -= maxSize;
                        newItemStack = itemstack.copy();
                        newItemStack.setCount(maxSize);
                        itemStacksInBundle.add(newItemStack);
                    }
                    if (numberOfItemWillPutIntoCurrentBundle > 0) {
                        newItemStack = itemstack.copy();
                        newItemStack.setCount(numberOfItemWillPutIntoCurrentBundle);
                        itemStacksInBundle.add(newItemStack);
                    }
                } else {
                    itemStackInBundle.grow(numberOfItemWillPut);
                }
                hasInsert = true;
                break;
            }
            if (!hasInsert && !isSelective) {
                int numberOfItemWillPutIntoCurrentBundle;
                int maxSize = itemstack.getMaxStackSize();
                for (numberOfItemWillPutIntoCurrentBundle = numberOfItemWillPut; numberOfItemWillPutIntoCurrentBundle > maxSize; numberOfItemWillPutIntoCurrentBundle -= maxSize) {
                    ItemStack newItemStack = itemstack.copy();
                    newItemStack.setCount(maxSize);
                    itemStacksInBundle.add(newItemStack);
                }
                if (numberOfItemWillPutIntoCurrentBundle > 0) {
                    ItemStack newItemStack = itemstack.copy();
                    newItemStack.setCount(numberOfItemWillPutIntoCurrentBundle);
                    itemStacksInBundle.add(newItemStack);
                }
                hasInsert = true;
            }
            if (!hasInsert) continue;
            itemstack.shrink(numberOfItemWillPut);
            bundleContentsComponent = new BundleContents(itemStacksInBundle);
            bundle.set(DataComponents.BUNDLE_CONTENTS, (Object)bundleContentsComponent);
            if (itemstack.isEmpty()) {
                entity.take((Entity)this, originalCount);
                entity.level().playSound(null, entity.blockPosition(), SoundEvents.DECORATED_POT_INSERT, SoundSource.PLAYERS, 0.3f, 0.8f + this.random.nextFloat() * 0.4f);
                entity.awardStat(Stats.ITEM_PICKED_UP.get((Object)itemstack.getItem()), originalCount);
                this.discard();
                ci.cancel();
                continue;
            }
            int pickedUpCount = originalCount - itemstack.getCount();
            if (pickedUpCount <= 0) continue;
            entity.take((Entity)this, pickedUpCount);
            entity.level().playSound(null, entity.blockPosition(), SoundEvents.DECORATED_POT_INSERT, SoundSource.PLAYERS, 0.3f, 0.8f + this.random.nextFloat() * 0.4f);
            entity.awardStat(Stats.ITEM_PICKED_UP.get((Object)itemstack.getItem()), pickedUpCount);
        }
    }
}

