/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.dayCounter;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={ServerLevel.class})
public abstract class ServerWorldMixin
extends Level
implements WorldGenLevel {
    @Unique
    private long begin_time;
    @Unique
    private long end_time;
    @Unique
    private boolean diversity_Multiloader$beginAnnounce = false;

    protected ServerWorldMixin(WritableLevelData properties, ResourceKey<Level> registryRef, RegistryAccess registryManager, Holder<DimensionType> dimensionEntry, Supplier<ProfilerFiller> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow
    @NotNull
    public abstract List<ServerPlayer> players();

    @Inject(method={"tickTime"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setDayTime(J)V")})
    private void tickTimeInject(CallbackInfo ci) {
        if (ModConfigs.day_counter <= 0) {
            return;
        }
        if (this.dimensionType().hasSkyLight() && this.getDayTime() % (long)ModConfigs.day_counter_tick_per_day == 0L) {
            if ((this.getDayTime() / (long)ModConfigs.day_counter_tick_per_day + 1L) % (long)ModConfigs.day_counter != 0L) {
                return;
            }
            this.diversity_Multiloader$beginAnnounce = true;
            this.begin_time = this.getDayTime();
            String message = "Day #" + (this.getDayTime() / (long)ModConfigs.day_counter_tick_per_day + 1L) + " has arrived!";
            this.end_time = this.begin_time + (long)message.length() * (long)ModConfigs.day_counter_speed + 80L;
        }
        this.diversity_Multiloader$announceNewDay();
    }

    @Unique
    private void diversity_Multiloader$announceNewDay() {
        if (!this.diversity_Multiloader$beginAnnounce) {
            return;
        }
        long current_time = this.getDayTime();
        if (current_time > this.end_time) {
            this.diversity_Multiloader$beginAnnounce = false;
            return;
        }
        if ((current_time - this.begin_time) % (long)ModConfigs.day_counter_speed == 0L) {
            String message = "Day #" + (current_time / (long)ModConfigs.day_counter_tick_per_day + 1L) + " has arrived!";
            for (ServerPlayer player : this.players()) {
                boolean playSound = true;
                int cut_pos = (int)((current_time - this.begin_time) / (long)ModConfigs.day_counter_speed);
                if (cut_pos < 0) {
                    this.diversity_Multiloader$beginAnnounce = false;
                    return;
                }
                if (cut_pos > message.length()) {
                    cut_pos = message.length();
                    playSound = false;
                }
                player.displayClientMessage((Component)Component.literal((String)(message.substring(0, cut_pos) + "_")).withStyle(ChatFormatting.GOLD).withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"diversity_day-counter")))), true);
                if (!playSound) continue;
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 0.1f, 1.4f);
            }
        }
    }
}

