/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.buildingBundle;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.compat.MetalBundles.MetalBundleItemInvoker;
import xyz.faewulf.diversity.inter.ICustomBundleContentBuilder;
import xyz.faewulf.diversity.inter.ICustomBundleItem;
import xyz.faewulf.diversity.mixin.item.buildingBundle.BlockItemInvoker;
import xyz.faewulf.diversity.platform.Services;
import xyz.faewulf.diversity.util.Utils;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.EnchantHelper;

@Mixin(value={BundleItem.class}, priority=1)
public abstract class BundleItemMixin
extends Item
implements ICustomBundleItem {
    public BundleItemMixin(Item.Properties settings) {
        super(settings);
    }

    @Unique
    private static int diversity_Multiloader$getMaxSize(ItemStack itemStack) {
        ItemEnchantments t = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        AtomicInteger level = new AtomicInteger(0);
        t.keySet().forEach(enchantmentRegistryEntry -> {
            ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
            if (enchantmentRegistryEntry.is(ResourceLocation.fromNamespaceAndPath((String)"diversity", (String)"capacity"))) {
                level.set(itemEnchantmentsComponent.getLevel(enchantmentRegistryEntry));
            }
        });
        return level.get() * 64 + 64;
    }

    @ModifyExpressionValue(method={"appendHoverText"}, at={@At(value="CONSTANT", args={"intValue=64"}, ordinal=1)})
    private int appendTooltipInject(int value, @Local(argsOnly=true) ItemStack stack) {
        return BundleItemMixin.diversity_Multiloader$getMaxSize(stack);
    }

    @Inject(method={"getBarWidth"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBarWidthInject(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        int usedSpace = Mth.mulAndTruncate((Fraction)((BundleContents)stack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).weight(), (int)64);
        int maxValue = BundleItemMixin.diversity_Multiloader$getMaxSize(stack);
        cir.setReturnValue((Object)((int)Math.clamp(Math.floor(13.0f * (float)usedSpace / (float)maxValue), 1.0, 13.0)));
        cir.cancel();
    }

    @Inject(method={"overrideOtherStackedOnMe"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BundleContents$Mutable;tryInsert(Lnet/minecraft/world/item/ItemStack;)I")})
    private void onClickedInject(ItemStack stack, ItemStack otherStack, Slot slot, ClickAction clickType, Player player, SlotAccess cursorStackReference, CallbackInfoReturnable<Boolean> cir, @Local BundleContents.Mutable builder) {
        ((ICustomBundleContentBuilder)builder).diversity_Multiloader$setMaxSize(this.diversity_Multiloader$getMaxSize(player.level(), stack));
    }

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BundleContents$Mutable;tryInsert(Lnet/minecraft/world/item/ItemStack;)I")})
    private void onStackClickedInject(ItemStack stack, Slot slot, ClickAction clickType, Player player, CallbackInfoReturnable<Boolean> cir, @Local BundleContents.Mutable builder) {
        ((ICustomBundleContentBuilder)builder).diversity_Multiloader$setMaxSize(this.diversity_Multiloader$getMaxSize(player.level(), stack));
    }

    @Inject(method={"overrideStackedOnOther"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/component/BundleContents$Mutable;tryTransfer(Lnet/minecraft/world/inventory/Slot;Lnet/minecraft/world/entity/player/Player;)I")})
    private void onStackClickedInject2(ItemStack stack, Slot slot, ClickAction clickType, Player player, CallbackInfoReturnable<Boolean> cir, @Local BundleContents.Mutable builder) {
        ((ICustomBundleContentBuilder)builder).diversity_Multiloader$setMaxSize(this.diversity_Multiloader$getMaxSize(player.level(), stack));
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!ModConfigs.bundle_place_mode) {
            return;
        }
        if (!world.isClientSide && user instanceof ServerPlayer && this.diversity_Multiloader$getMode(user.getItemInHand(hand)) != 0) {
            this.diversity_Multiloader$syncBundleContents((ServerPlayer)user);
            cir.setReturnValue((Object)InteractionResultHolder.fail((Object)user.getItemInHand(hand)));
        }
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        if (!ModConfigs.bundle_place_mode) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        Player player = context.getPlayer();
        if (world.isClientSide) {
            return InteractionResult.PASS;
        }
        ItemStack bundle = context.getItemInHand();
        if (this.diversity_Multiloader$getMode(bundle) == 0) {
            return InteractionResult.PASS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (player instanceof ServerPlayer) {
                BundleContents bundleContentsComponent;
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                Object object = bundle.get(DataComponents.BUNDLE_CONTENTS);
                if (object instanceof BundleContents && !(bundleContentsComponent = (BundleContents)object).isEmpty()) {
                    BlockItem blockItem;
                    InteractionResult actionResult;
                    ArrayList<Integer> blockItemList = new ArrayList<Integer>();
                    for (int i = 0; i < bundleContentsComponent.size(); ++i) {
                        Item item = bundleContentsComponent.getItemUnsafe(i).getItem();
                        if (Compare.isHasTag((Item)item, (String)"diversity:bundle_place_mode_blacklist") || !(item instanceof BlockItem)) continue;
                        blockItemList.add(i);
                    }
                    if (blockItemList.isEmpty()) {
                        return InteractionResult.PASS;
                    }
                    int chosenIndex = this.diversity_Multiloader$getMode(bundle) == 2 ? (Integer)blockItemList.get(serverPlayerEntity.getRandom().nextInt(blockItemList.size())) : (Integer)blockItemList.getFirst();
                    Item item = bundleContentsComponent.getItemUnsafe(chosenIndex).getItem();
                    if (item instanceof BlockItem && ((actionResult = (blockItem = (BlockItem)item).useOn(context)) == InteractionResult.CONSUME || actionResult == InteractionResult.SUCCESS)) {
                        this.diversity_Multiloader$removeItem(player, bundle, bundleContentsComponent, chosenIndex);
                        BlockState blockState = blockItem.getBlock().defaultBlockState();
                        SoundEvent soundEvent = ((BlockItemInvoker)blockItem).invokeGetPlaceSound(blockState);
                        serverWorld.playSound(null, context.getClickedPos(), soundEvent, SoundSource.BLOCKS, 1.0f, 0.8f);
                        player.swing(context.getHand(), true);
                        player.awardStat(Stats.ITEM_USED.get((Object)blockItem));
                        return InteractionResult.CONSUME;
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Unique
    private void diversity_Multiloader$removeItem(Player player, ItemStack bundleItem, BundleContents bundleContentsComponent, int index) {
        if (bundleContentsComponent.isEmpty() || bundleContentsComponent.size() < index + 1) {
            return;
        }
        ItemStack itemStack = bundleContentsComponent.getItemUnsafe(index);
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>(bundleContentsComponent.itemCopyStream().toList());
        if (itemStack.getCount() < 1) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        if (itemStack.getCount() > 1) {
            ((ItemStack)itemStacks.get(index)).shrink(1);
            bundleContentsComponent = new BundleContents(itemStacks);
            bundleItem.set(DataComponents.BUNDLE_CONTENTS, (Object)bundleContentsComponent);
            return;
        }
        boolean isRefilled = false;
        if (this.diversity_Multiloader$isRefillable(player.level(), bundleItem)) {
            isRefilled = this.diversity_Multiloader$refill(player, bundleItem, bundleContentsComponent, itemStacks, index);
        }
        if (!isRefilled) {
            itemStacks.remove(index);
            player.displayClientMessage((Component)Component.literal((String)("Ran out of " + itemStack.getItem().getDescription().getString())), true);
        }
        bundleContentsComponent = new BundleContents(itemStacks);
        bundleItem.set(DataComponents.BUNDLE_CONTENTS, (Object)bundleContentsComponent);
    }

    @Unique
    private void diversity_Multiloader$syncBundleContents(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundContainerSetContentPacket(player.inventoryMenu.containerId, 0, player.inventoryMenu.getItems(), player.inventoryMenu.getCarried()));
    }

    @Unique
    private boolean diversity_Multiloader$refill(Player player, ItemStack bundle, BundleContents bundleContentsComponent, List<ItemStack> itemStacks, int index) {
        int maxBundleSize;
        Inventory playerInventory = player.getInventory();
        int indexOfItemInInventory = playerInventory.findSlotMatchingItem(itemStacks.get(index));
        if (indexOfItemInInventory == -1) {
            return false;
        }
        ItemStack itemStackWillPutInto = playerInventory.getItem(indexOfItemInInventory);
        int stackMultiplier = 64 / itemStackWillPutInto.getMaxStackSize();
        int realStackSizeOfTheItemWillPutInto = stackMultiplier * itemStackWillPutInto.getCount();
        int usedSlotInBundle = Mth.mulAndTruncate((Fraction)bundleContentsComponent.weight(), (int)64) - stackMultiplier;
        if (usedSlotInBundle >= (maxBundleSize = this.diversity_Multiloader$getMaxSize(player.level(), bundle))) {
            return false;
        }
        int freeSlotInBundle = maxBundleSize - usedSlotInBundle;
        int numberOfItemWillPut = (int)Math.floor((float)Math.min(freeSlotInBundle, realStackSizeOfTheItemWillPutInto) * 1.0f / (float)stackMultiplier);
        itemStackWillPutInto.consume(numberOfItemWillPut, (LivingEntity)player);
        itemStacks.get(index).grow(numberOfItemWillPut - 1);
        player.level().playSound(null, player.blockPosition(), SoundEvents.DECORATED_POT_INSERT, SoundSource.PLAYERS, 0.5f, 1.0f);
        return true;
    }

    @Unique
    private boolean diversity_Multiloader$isRefillable(Level world, ItemStack itemStack) {
        if (world.isClientSide) {
            return false;
        }
        return EnchantHelper.hasEnchantment((Level)world, (ItemStack)itemStack, (String)"diversity", (String)"refill");
    }

    @Unique
    private int diversity_Multiloader$getMaxSize(Level world, ItemStack itemStack) {
        int originalSize = 64;
        if (Services.PLATFORM.isModLoaded("metalbundles")) {
            Fraction a = MetalBundleItemInvoker.getActualWeightInvoker(itemStack);
            int usedSpace = Mth.mulAndTruncate((Fraction)((BundleContents)itemStack.getOrDefault(DataComponents.BUNDLE_CONTENTS, (Object)BundleContents.EMPTY)).weight(), (int)64);
            originalSize = Utils.recoverCapacity(a, usedSpace);
        }
        int value = EnchantHelper.getEnchantLevelFromItem((Level)world, (ItemStack)itemStack, (String)"diversity", (String)"capacity");
        return originalSize + value * 64;
    }

    @Override
    public int diversity_Multiloader$getMode(ItemStack itemStack) {
        CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        if (customData.contains("diversity:mode")) {
            return customData.copyTag().getInt("diversity:mode");
        }
        return 0;
    }

    @Override
    public void diversity_Multiloader$setMode(ItemStack itemStack, int mode) {
        final String modeText = switch (mode) {
            case 1 -> "place first slot";
            case 2 -> "place random slot";
            default -> "normal";
        };
        itemStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, comp -> comp.update(currentNbt -> currentNbt.putInt("diversity:mode", mode)));
        itemStack.set(DataComponents.LORE, (Object)new ItemLore((List)new ArrayList<Component>(){
            {
                this.add(Component.literal((String)("Mode: " + modeText)).withStyle(ChatFormatting.GRAY));
            }
        }));
    }
}

