/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util.gameTests.entry.entity;

import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.Blocks;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.gameTests.TestGroup;

@TestGroup
public class horseSitOnBoat {
    @GameTest(template="faewulf_lib:default")
    public void test1(GameTestHelper helper) {
        if (!ModConfigs.horse_can_seat_on_boat) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        Boat boat = (Boat)helper.spawn(EntityType.BOAT, 4, 2, 4);
        Horse horse = (Horse)helper.spawn(EntityType.HORSE, 1, 3, 1);
        Camel camel = (Camel)helper.spawn(EntityType.CAMEL, 8, 3, 8);
        helper.startSequence().thenExecute(() -> {
            helper.moveTo((Mob)camel, 4.0f, 2.0f, 4.0f);
            helper.moveTo((Mob)horse, 4.0f, 2.0f, 4.0f);
        }).thenExecuteAfter(40, () -> {
            if (boat.getPassengers().size() != 2) {
                helper.fail(boat.getPassengers().toString());
            }
        }).thenSucceed();
    }

    @GameTest(template="faewulf_lib:default")
    public void test2(GameTestHelper helper) {
        if (!ModConfigs.horse_can_seat_on_boat) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        Boat boat = (Boat)helper.spawn(EntityType.BOAT, 4, 2, 4);
        Donkey donkey = (Donkey)helper.spawn(EntityType.DONKEY, 2, 2, 1);
        Mule mule = (Mule)helper.spawn(EntityType.MULE, 8, 3, 8);
        helper.startSequence().thenExecute(() -> {
            helper.moveTo((Mob)donkey, 4.0f, 2.0f, 4.0f);
            helper.moveTo((Mob)mule, 4.0f, 2.0f, 4.0f);
        }).thenExecuteAfter(40, () -> {
            if (boat.getPassengers().size() != 2) {
                helper.fail(boat.getPassengers().toString());
            }
        }).thenSucceed();
    }
}

