/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.curse.reversePhantom;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.feature.player.sleepCounter.PlayerSleepStat;

@Mixin(value={ServerPlayer.class})
public abstract class PlayerMixin
extends Player
implements PlayerSleepStat {
    @Unique
    private int diversity_Multiloader$sleepStrike = 0;
    @Unique
    private int diversity_Multiloader$hasSleep = 0;

    public PlayerMixin(Level pLevel, BlockPos pPos, float pYRot, GameProfile pGameProfile) {
        super(pLevel, pPos, pYRot, pGameProfile);
    }

    @Shadow
    public abstract ServerLevel serverLevel();

    @Inject(method={"die"}, at={@At(value="TAIL")})
    private void dieInject(DamageSource pCause, CallbackInfo ci) {
        this.diversity_Multiloader$sleepStrike = 0;
    }

    @Inject(method={"stopSleepInBed"}, at={@At(value="TAIL")})
    private void stopSleepInBedInject(boolean pWakeImmediately, boolean pUpdateLevelForSleepingPlayers, CallbackInfo ci) {
        if (!pWakeImmediately && !pUpdateLevelForSleepingPlayers) {
            ++this.diversity_Multiloader$sleepStrike;
            this.diversity_Multiloader$hasSleep = 1;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickInject(CallbackInfo ci) {
        if (this.serverLevel().getDayTime() % 24000L == 20L && this.diversity_Multiloader$hasSleep == 0) {
            this.diversity_Multiloader$sleepStrike = 0;
        }
        if (this.serverLevel().getDayTime() % 24000L > 20L) {
            this.diversity_Multiloader$hasSleep = 0;
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void saveDataInject(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.putInt("diversity:sleep_strike", this.diversity_Multiloader$sleepStrike);
        pCompound.putInt("diversity:has_sleep", this.diversity_Multiloader$hasSleep);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void loadDataInject(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.contains("diversity:sleep_strike", 3)) {
            this.diversity_Multiloader$sleepStrike = pCompound.getInt("diversity:sleep_strike");
        }
        if (pCompound.contains("diversity:has_sleep", 3)) {
            this.diversity_Multiloader$hasSleep = pCompound.getInt("diversity:has_sleep");
        }
    }

    @Override
    public int diversity_Multiloader$getSleepStreak() {
        return this.diversity_Multiloader$sleepStrike;
    }

    @Override
    public void diversity_Multiloader$setSleepStreak(int value) {
        this.diversity_Multiloader$sleepStrike = value;
    }
}

