/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.general.bannerTrophy;

import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.faewulf.diversity.util.CustomBanner;
import xyz.faewulf.diversity.util.config.ModConfigs;

@Mixin(value={LivingEntity.class})
public abstract class WardenSuperClassMixin
extends Entity
implements Attackable {
    public WardenSuperClassMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"die"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/DamageSource;getEntity()Lnet/minecraft/world/entity/Entity;")})
    private void onDeathInject(DamageSource damageSource, CallbackInfo ci) {
        if (!ModConfigs.banner_trohpy) {
            return;
        }
        WardenSuperClassMixin wardenSuperClassMixin = this;
        if (wardenSuperClassMixin instanceof Warden) {
            Warden wardenEntity = (Warden)wardenSuperClassMixin;
            ItemStack wardenBanner = CustomBanner.wardenBanner((HolderGetter<BannerPattern>)wardenEntity.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN));
            wardenBanner.setCount(1);
            wardenEntity.spawnAtLocation(wardenBanner);
        }
    }
}

