/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.util.gameTests.entry.general;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.EnchantHelper;
import xyz.faewulf.lib.util.gameTests.TestGroup;

@TestGroup
public class preventFarmlandTrampling {
    @GameTest(template="faewulf_lib:default")
    public void test(GameTestHelper helper) {
        if (!ModConfigs.prevent_farmland_trampling) {
            helper.setBlock(8, 8, 8, Blocks.RED_CONCRETE);
        }
        helper.setBlock(4, 1, 6, Blocks.FARMLAND);
        helper.setBlock(4, 1, 2, Blocks.FARMLAND);
        helper.setBlock(6, 1, 4, Blocks.FARMLAND);
        helper.setBlock(4, 1, 4, (BlockState)Blocks.COPPER_GRATE.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
        helper.startSequence().thenExecute(() -> {
            Zombie zombie_slowfall = (Zombie)helper.spawnWithNoFreeWill(EntityType.HUSK, new BlockPos(4, 4, 6).getCenter());
            zombie_slowfall.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 999));
            Zombie zombie_armor = (Zombie)helper.spawnWithNoFreeWill(EntityType.HUSK, new BlockPos(4, 4, 2).getCenter());
            ItemStack feather_boots = new ItemStack((ItemLike)Items.DIAMOND_BOOTS);
            feather_boots.enchant(EnchantHelper.getEnchant((Level)helper.getLevel(), (ResourceKey)Enchantments.FEATHER_FALLING), 1);
            zombie_armor.setItemSlot(EquipmentSlot.FEET, feather_boots);
            Zombie zombie_normal = (Zombie)helper.spawnWithNoFreeWill(EntityType.HUSK, new BlockPos(6, 4, 4).getCenter());
        }).thenExecuteAfter(60, () -> {
            helper.assertBlockPresent(Blocks.FARMLAND, new BlockPos(4, 1, 6));
            helper.assertBlockPresent(Blocks.FARMLAND, new BlockPos(4, 1, 2));
            helper.assertBlockPresent(Blocks.DIRT, new BlockPos(6, 1, 4));
        }).thenSucceed();
    }
}

