/*
 * Decompiled with CFR 0.152.
 */
package xyz.faewulf.diversity.mixin.item.buildingBundle;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.faewulf.diversity.inter.ICustomBundleItem;
import xyz.faewulf.diversity.mixin.item.buildingBundle.BlockItemInvoker;
import xyz.faewulf.diversity.util.CustomEnchant;
import xyz.faewulf.diversity.util.config.ModConfigs;
import xyz.faewulf.lib.util.Compare;
import xyz.faewulf.lib.util.missingMethod.ItemStackMethod;

@Mixin(value={BundleItem.class}, priority=1)
public abstract class BundleItemMixin
extends Item
implements ICustomBundleItem {
    @Shadow
    private static Stream<ItemStack> m_150782_(ItemStack $$0) {
        return null;
    }

    @Shadow
    private static int m_150776_(ItemStack $$0) {
        return 0;
    }

    @Shadow
    private static int m_150778_(ItemStack $$0) {
        return 0;
    }

    public BundleItemMixin(Item.Properties settings) {
        super(settings);
    }

    @Unique
    private static int diversity_Multiloader$getMaxSize(ItemStack itemStack) {
        int originalSize = 64;
        int value = EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.CAPACITY, (ItemStack)itemStack);
        return originalSize + value * 64;
    }

    @Inject(method={"getBarWidth"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBarWidthInject(ItemStack stack, CallbackInfoReturnable<Integer> cir) {
        int usedSpace = BundleItemMixin.m_150778_(stack);
        int maxValue = BundleItemMixin.diversity_Multiloader$getMaxSize(stack);
        cir.setReturnValue((Object)((int)Math.floor(13.0f * (float)usedSpace / (float)maxValue)));
        cir.cancel();
    }

    @ModifyExpressionValue(method={"appendHoverText"}, at={@At(value="CONSTANT", args={"intValue=64"}, ordinal=0)})
    private int appendTooltipInject(int value, @Local(argsOnly=true) ItemStack stack) {
        return Math.max(value, BundleItemMixin.diversity_Multiloader$getMaxSize(stack));
    }

    @ModifyExpressionValue(method={"add"}, at={@At(value="CONSTANT", args={"intValue=64"})})
    private static int modifyMaxBundleValue(int original, @Local(ordinal=0, argsOnly=true) ItemStack bundle) {
        return BundleItemMixin.diversity_Multiloader$getMaxSize(bundle);
    }

    @ModifyExpressionValue(method={"overrideStackedOnOther"}, at={@At(value="CONSTANT", args={"intValue=64"})})
    private int modifyMaxBundleValue2(int original, @Local(ordinal=0, argsOnly=true) ItemStack bundle) {
        return BundleItemMixin.diversity_Multiloader$getMaxSize(bundle);
    }

    @ModifyExpressionValue(method={"add"}, at={@At(value="INVOKE", target="Ljava/util/Optional;isPresent()Z")})
    private static boolean modifyIfCase(boolean original, @Local(ordinal=2) int k) {
        if (ModConfigs.bundle_enchantment) {
            return false;
        }
        return original;
    }

    @Inject(method={"add"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/ListTag;add(ILnet/minecraft/nbt/Tag;)V", shift=At.Shift.AFTER)})
    private static void modifyListTag_extra_sort(ItemStack $$0, ItemStack $$1, CallbackInfoReturnable<Integer> cir, @Local ListTag listTag) {
        HashMap<CompoundTag, Integer> map = new HashMap<CompoundTag, Integer>();
        for (Tag tag : listTag) {
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag compoundTag2 = (CompoundTag)tag;
            AtomicBoolean isExist = new AtomicBoolean(false);
            map.forEach((compoundTag1, integer) -> {
                if (ItemStack.m_150942_((ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag1), (ItemStack)ItemStack.m_41712_((CompoundTag)compoundTag2))) {
                    integer = integer + compoundTag2.m_128445_("Count");
                    map.put((CompoundTag)compoundTag1, (Integer)integer);
                    isExist.set(true);
                }
            });
            if (isExist.get()) continue;
            map.put(compoundTag2, Integer.valueOf(compoundTag2.m_128445_("Count")));
        }
        listTag.clear();
        map.forEach((compoundTag, integer) -> {
            CompoundTag insertOne;
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)compoundTag);
            while (integer > itemStack.m_41741_()) {
                insertOne = compoundTag.m_6426_();
                insertOne.m_128344_("Count", (byte)itemStack.m_41741_());
                listTag.add((Object)insertOne);
                integer = integer - itemStack.m_41741_();
            }
            insertOne = compoundTag.m_6426_();
            insertOne.m_128344_("Count", integer.byteValue());
            listTag.add((Object)insertOne);
        });
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void use(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (!ModConfigs.bundle_place_mode) {
            return;
        }
        if (!world.f_46443_ && user instanceof ServerPlayer && this.multiLoader_1_20_1$getMode(user.m_21120_(hand)) != 0) {
            this.multiLoader_1_20_1$syncBundleContents((ServerPlayer)user);
            cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)user.m_21120_(hand)));
        }
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        if (!ModConfigs.bundle_place_mode) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack bundle = context.m_43722_();
        if (this.multiLoader_1_20_1$getMode(bundle) == 0) {
            return InteractionResult.PASS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                Item item = bundle.m_41720_();
                if (item instanceof BundleItem) {
                    BundleItem bundleItem = (BundleItem)item;
                    if (BundleItemMixin.m_150778_(bundle) > 0) {
                        BlockItem blockItem;
                        InteractionResult actionResult;
                        Stream<ItemStack> itemStackStream = BundleItemMixin.m_150782_(bundle);
                        if (itemStackStream == null) {
                            return InteractionResult.PASS;
                        }
                        LinkedList<ItemStack> itemStackListFromBundle = new LinkedList<ItemStack>(itemStackStream.toList());
                        ArrayList<Integer> blockItemList = new ArrayList<Integer>();
                        for (int i = 0; i < itemStackListFromBundle.size(); ++i) {
                            Item item2 = ((ItemStack)itemStackListFromBundle.get(i)).m_41720_();
                            if (Compare.isHasTag((Item)item2, (String)"diversity:bundle_place_mode_blacklist") || !(item2 instanceof BlockItem)) continue;
                            blockItemList.add(i);
                        }
                        if (blockItemList.isEmpty()) {
                            return InteractionResult.PASS;
                        }
                        int chosenIndex = this.multiLoader_1_20_1$getMode(bundle) == 2 ? (Integer)blockItemList.get(serverPlayerEntity.m_217043_().m_188503_(blockItemList.size())) : (Integer)blockItemList.get(0);
                        Item item3 = ((ItemStack)itemStackListFromBundle.get(chosenIndex)).m_41720_();
                        if (item3 instanceof BlockItem && ((actionResult = (blockItem = (BlockItem)item3).m_6225_(context)) == InteractionResult.CONSUME || actionResult == InteractionResult.SUCCESS)) {
                            this.multiLoader_1_20_1$removeItem(player, bundle, itemStackListFromBundle, chosenIndex);
                            BlockState blockState = blockItem.m_40614_().m_49966_();
                            SoundEvent soundEvent = ((BlockItemInvoker)blockItem).invokeGetPlaceSound(blockState);
                            serverWorld.m_5594_(null, context.m_8083_(), soundEvent, SoundSource.BLOCKS, 1.0f, 0.8f);
                            player.m_21011_(context.m_43724_(), true);
                            player.m_36246_(Stats.f_12982_.m_12902_((Object)blockItem));
                            return InteractionResult.CONSUME;
                        }
                    }
                }
            }
        }
        return InteractionResult.PASS;
    }

    @Unique
    private void multiLoader_1_20_1$removeItem(Player player, ItemStack bundleItem, List<ItemStack> bundleContentsComponent, int index) {
        if (bundleContentsComponent.isEmpty() || bundleContentsComponent.size() < index + 1) {
            return;
        }
        ItemStack itemStack = bundleContentsComponent.get(index);
        if (itemStack.m_41613_() < 1) {
            return;
        }
        if (player.m_7500_()) {
            return;
        }
        if (itemStack.m_41613_() > 1) {
            bundleContentsComponent.get(index).m_41774_(1);
            this.multiLoader_1_20_1$saveItemListToBundle(bundleContentsComponent, bundleItem);
            return;
        }
        boolean isRefilled = false;
        if (this.multiLoader_1_20_1$isRefillable(player.m_9236_(), bundleItem)) {
            isRefilled = this.multiLoader_1_20_1$refill(player, bundleItem, bundleContentsComponent, index);
        }
        if (!isRefilled) {
            bundleContentsComponent.remove(index);
            player.m_5661_((Component)Component.m_237113_((String)("Ran out of " + itemStack.m_41720_().m_41466_().getString())), true);
        }
        this.multiLoader_1_20_1$saveItemListToBundle(bundleContentsComponent, bundleItem);
    }

    @Unique
    private void multiLoader_1_20_1$saveItemListToBundle(List<ItemStack> itemStackList, ItemStack bundle) {
        CompoundTag bundleTag = bundle.m_41784_();
        ListTag itemsTagList = new ListTag();
        for (ItemStack item : itemStackList) {
            if (item.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            itemsTagList.add((Object)itemTag);
        }
        bundleTag.m_128365_("Items", (Tag)itemsTagList);
        bundle.m_41751_(bundleTag);
    }

    @Unique
    private void multiLoader_1_20_1$syncBundleContents(ServerPlayer player) {
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetContentPacket(player.f_36095_.f_38840_, 0, player.f_36095_.m_38927_(), player.f_36095_.m_142621_()));
    }

    @Unique
    private boolean multiLoader_1_20_1$refill(Player player, ItemStack bundle, List<ItemStack> itemStacks, int index) {
        int maxBundleSize;
        Inventory playerInventory = player.m_150109_();
        int indexOfItemInInventory = playerInventory.m_36030_(itemStacks.get(index));
        if (indexOfItemInInventory == -1) {
            return false;
        }
        ItemStack itemStackWillPutInto = playerInventory.m_8020_(indexOfItemInInventory);
        int stackMultiplier = 64 / itemStackWillPutInto.m_41741_();
        int realStackSizeOfTheItemWillPutInto = stackMultiplier * itemStackWillPutInto.m_41613_();
        int usedSlotInBundle = BundleItemMixin.m_150778_(bundle);
        if (usedSlotInBundle >= (maxBundleSize = BundleItemMixin.diversity_Multiloader$getMaxSize(bundle))) {
            return false;
        }
        int freeSlotInBundle = maxBundleSize - usedSlotInBundle;
        int numberOfItemWillPut = (int)Math.floor((float)Math.min(freeSlotInBundle, realStackSizeOfTheItemWillPutInto) * 1.0f / (float)stackMultiplier);
        ItemStackMethod.consume((ItemStack)itemStackWillPutInto, (int)numberOfItemWillPut, (LivingEntity)player);
        itemStacks.get(index).m_41769_(numberOfItemWillPut - 1);
        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11696_, SoundSource.PLAYERS, 0.5f, 0.7f);
        return true;
    }

    @Unique
    private boolean multiLoader_1_20_1$isRefillable(Level world, ItemStack itemStack) {
        if (world.f_46443_) {
            return false;
        }
        int value = EnchantmentHelper.m_44843_((Enchantment)CustomEnchant.REFILL, (ItemStack)itemStack);
        return value > 0;
    }

    @Override
    public int multiLoader_1_20_1$getMode(ItemStack itemStack) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt.m_128425_("diversity:mode", 3)) {
            return nbt.m_128451_("diversity:mode");
        }
        return 0;
    }

    @Override
    public void multiLoader_1_20_1$setMode(ItemStack itemStack, int mode) {
        String modeText = switch (mode) {
            case 1 -> "place first slot";
            case 2 -> "place random slot";
            default -> "normal";
        };
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128405_("diversity:mode", mode);
        CompoundTag displayTag = itemStack.m_41698_("display");
        ListTag loreTag = new ListTag();
        loreTag.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)("Mode: " + modeText)).m_130940_(ChatFormatting.GRAY))));
        displayTag.m_128365_("Lore", (Tag)loreTag);
    }
}

