/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component;

import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IConfigEntryComponent;
import com.daqem.yamlconfig.client.gui.component.TruncatedKeyTextComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.Nullable;

public class ConfigCategoryComponent
extends AbstractComponent {
    private final IStackConfigEntry stackConfigEntry;
    @Nullable
    private final String key;
    private final List<IConfigEntryComponent<?>> configEntryComponents;
    private final List<ConfigCategoryComponent> subCategories;

    public ConfigCategoryComponent(IStackConfigEntry stackConfigEntry, @Nullable String key, List<IConfigEntryComponent<?>> configEntryComponents) {
        this(stackConfigEntry, key, configEntryComponents, new ArrayList<ConfigCategoryComponent>());
    }

    public ConfigCategoryComponent(IStackConfigEntry stackConfigEntry, @Nullable String key, List<IConfigEntryComponent<?>> configEntryComponents, List<ConfigCategoryComponent> subCategories) {
        super(0, 0, 314, 0);
        this.stackConfigEntry = stackConfigEntry;
        this.key = key;
        this.configEntryComponents = configEntryComponents;
        this.subCategories = subCategories;
        if (key != null) {
            this.addComponent((IComponent)new TruncatedKeyTextComponent(key, this.getWidth(), stackConfigEntry, true));
        }
        this.addComponents(configEntryComponents);
        this.addComponents(subCategories);
    }

    public int getWidth() {
        return 314;
    }

    public int getHeight() {
        int height = 0;
        if (this.key != null) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            height += 9 + 6;
        }
        for (IConfigEntryComponent<?> entry : this.configEntryComponents) {
            height += entry.getHeight() + 10;
        }
        for (int i = 0; i < this.subCategories.size(); ++i) {
            if (i < this.subCategories.size() - 1) {
                height += 10;
            }
            height += this.subCategories.get(i).getHeight();
        }
        return height;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        this.renderHorizontalLines(guiGraphics);
        int currentY = 0;
        if (this.key != null) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            currentY += 9 + 12;
        }
        for (IConfigEntryComponent<?> entry : this.configEntryComponents) {
            entry.setY(currentY);
            currentY += entry.getHeight() + 10;
        }
        for (int i = 0; i < this.subCategories.size(); ++i) {
            ConfigCategoryComponent subCategory = this.subCategories.get(i);
            if (i < this.subCategories.size() - 1) {
                currentY += 10;
            }
            subCategory.setY(currentY);
            currentY += subCategory.getHeight();
        }
    }

    public void addSubCategory(ConfigCategoryComponent subCategory) {
        if (subCategory == this) {
            throw new IllegalArgumentException("Cannot add a category to itself");
        }
        if (!this.subCategories.contains((Object)subCategory)) {
            this.subCategories.add(subCategory);
            this.addComponent((IComponent)subCategory);
        }
    }

    private void renderHorizontalLines(GuiGraphics graphics) {
        if (this.key == null) {
            return;
        }
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineYStart = 9 + 6;
        graphics.fill(this.getTotalX(), this.getTotalY() + lineYStart, this.getTotalX() + this.getWidth(), this.getTotalY() + lineYStart + 1, -1);
    }

    public List<IConfigEntryComponent<?>> getAllConfigEntryComponents() {
        ArrayList allConfigEntryComponents = new ArrayList(this.configEntryComponents);
        this.subCategories.forEach(subCategory -> allConfigEntryComponents.addAll(subCategory.getAllConfigEntryComponents()));
        return allConfigEntryComponents;
    }
}

