/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component;

import com.daqem.uilib.gui.component.text.TruncatedTextComponent;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TruncatedKeyTextComponent
extends TruncatedTextComponent {
    @Nullable
    private final IConfigEntry<?> configEntry;

    public TruncatedKeyTextComponent(String key, int maxWidth, @Nullable IConfigEntry<?> configEntry, boolean bold) {
        super(0, 5, maxWidth, (Component)YamlConfig.translatable(key).withStyle(Style.EMPTY.withBold(Boolean.valueOf(bold))));
        this.configEntry = configEntry;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        List<String> comments;
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        if (this.configEntry != null && this.getRectangle().containsPoint(mouseX, mouseY) && !(comments = this.configEntry.getComments().getComments(false)).isEmpty()) {
            guiGraphics.setTooltipForNextFrame(this.getFont(), Language.getInstance().getVisualOrder(comments.stream().map(Component::literal).map(comment -> comment).toList()), mouseX, mouseY);
        }
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getTotalX(), this.getTotalY(), this.getWidth(), this.getHeight());
    }
}

