/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.list;

import com.daqem.uilib.api.widget.IInputValidatable;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.ButtonWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.entry.list.IListConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IComponentValidator;
import com.daqem.yamlconfig.client.gui.component.CrossButtonComponent;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public abstract class BaseListConfigEntryComponent<C extends IListConfigEntry<?>>
extends BaseConfigEntryComponent<C> {
    private static final int WIDTH = 290;
    protected final Map<EditBoxWidget, CrossButtonComponent> editBoxWidgets;
    protected final ButtonWidget addEntryButton;
    private final IComponentValidator validator;

    public BaseListConfigEntryComponent(String key, C configEntry, IComponentValidator validator) {
        super(key, configEntry, 0, 0, BaseListConfigEntryComponent.calculateInitialHeight(configEntry), 290);
        this.validator = validator;
        this.editBoxWidgets = this.createEditBoxWidgets((List)((IListConfigEntry)this.getConfigEntry()).get());
        this.addEntryButton = this.createAddEntryButton();
        this.addWidgets(new ArrayList<EditBoxWidget>(this.editBoxWidgets.keySet()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.addWidget((IWidget)this.addEntryButton);
    }

    private static int calculateInitialHeight(IListConfigEntry<?> configEntry) {
        int entryCount = ((List)configEntry.get()).size();
        return 44 + entryCount * 24;
    }

    private ButtonWidget createAddEntryButton() {
        return new ButtonWidget(0, this.getHeight() - 20, 290, 20, (Component)YamlConfig.translatable("gui.add_entry"), this::handleAddEntryButtonClick);
    }

    private void handleAddEntryButtonClick(Button button) {
        EditBoxWidget newTextBox = this.createEditBoxWidget(this.editBoxWidgets.size());
        CrossButtonComponent newCrossButton = this.createCrossButtonComponent(newTextBox);
        this.editBoxWidgets.put(newTextBox, newCrossButton);
        this.addWidget((IWidget)newTextBox);
        this.addWidget((IWidget)newCrossButton);
        this.adjustLayoutForNewEntry(button);
    }

    private EditBoxWidget createEditBoxWidget(int index) {
        return new EditBoxWidget(Minecraft.getInstance().font, 0, index * 24 + 20 + 4, 290, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                return BaseListConfigEntryComponent.this.validator.validate(input);
            }
        };
    }

    private CrossButtonComponent createCrossButtonComponent(EditBoxWidget EditBoxWidget2) {
        return new CrossButtonComponent(297, EditBoxWidget2.getY() + 3, button -> this.handleRemoveEntryButtonClick(EditBoxWidget2, (CrossButtonComponent)button));
    }

    private void handleRemoveEntryButtonClick(EditBoxWidget EditBoxWidget2, CrossButtonComponent crossButtonComponent) {
        this.removeEntry(EditBoxWidget2, crossButtonComponent);
    }

    private void removeEntry(EditBoxWidget editBoxWidget, CrossButtonComponent crossButtonWidget) {
        this.removeWidget((IWidget)crossButtonWidget);
        this.removeWidget((IWidget)editBoxWidget);
        this.editBoxWidgets.remove(editBoxWidget);
        this.adjustLayoutForRemovedEntry();
    }

    private void adjustLayoutForNewEntry(Button addEntryButton) {
        this.setHeight(this.getHeight() + 20 + 4);
        addEntryButton.setY(this.getHeight() - 20);
    }

    private void adjustLayoutForRemovedEntry() {
        this.setHeight(this.getHeight() - 20 - 4);
        this.addEntryButton.setY(this.getHeight() - 20);
        this.updateComponentPositions();
    }

    private void updateComponentPositions() {
        int index = 0;
        for (Map.Entry<EditBoxWidget, CrossButtonComponent> entry : this.editBoxWidgets.entrySet()) {
            int yPosition = index * 24 + 20 + 4;
            entry.getKey().setY(yPosition);
            entry.getValue().setY(yPosition + 3);
            ++index;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        this.renderHorizontalLines(guiGraphics);
        this.addEntryButton.active = ((IListConfigEntry)this.getConfigEntry()).getMaxLength() > this.editBoxWidgets.size();
        this.editBoxWidgets.values().forEach(crossButtonComponent -> {
            crossButtonComponent.active = ((IListConfigEntry)this.getConfigEntry()).getMinLength() < this.editBoxWidgets.size();
        });
    }

    private void renderHorizontalLines(GuiGraphics graphics) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineYStart = 9 + 6;
        graphics.fill(this.getTotalX(), this.getTotalY() + lineYStart, this.getTotalX() + 290, this.getTotalY() + lineYStart + 1, -1);
    }

    @Override
    public boolean isOriginalValue() {
        List<String> currentValues = this.editBoxWidgets.keySet().stream().map(EditBox::getValue).toList();
        List<String> originalValues = ((List)((IListConfigEntry)this.getConfigEntry()).getDefaultValue()).stream().map(Object::toString).toList();
        return currentValues.equals(originalValues);
    }

    @Override
    public void resetValue() {
        this.clearEntries();
        this.editBoxWidgets.putAll(this.createEditBoxWidgets((List)((IListConfigEntry)this.getConfigEntry()).getDefaultValue()));
        this.addWidgets(new ArrayList<EditBoxWidget>(this.editBoxWidgets.keySet()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.resetLayout();
    }

    private void clearEntries() {
        this.editBoxWidgets.keySet().forEach(arg_0 -> ((BaseListConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.values().forEach(arg_0 -> ((BaseListConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.clear();
    }

    private void resetLayout() {
        int newHeight = BaseListConfigEntryComponent.calculateInitialHeight((IListConfigEntry)this.getConfigEntry());
        this.setHeight(newHeight);
        this.addEntryButton.setY(newHeight - 20);
    }

    private Map<EditBoxWidget, CrossButtonComponent> createEditBoxWidgets(List<?> configValues) {
        LinkedHashMap<EditBoxWidget, CrossButtonComponent> components = new LinkedHashMap<EditBoxWidget, CrossButtonComponent>();
        for (int i = 0; i < configValues.size(); ++i) {
            EditBoxWidget textBox = this.createEditBoxWidget(i);
            textBox.setValue(configValues.get(i).toString());
            CrossButtonComponent crossButton = this.createCrossButtonComponent(textBox);
            components.put(textBox, crossButton);
        }
        return components;
    }

    public boolean hasInputValidationErrors() {
        return this.editBoxWidgets.keySet().stream().anyMatch(IInputValidatable::hasInputValidationErrors);
    }

    @Override
    public boolean hasValidationErrors() {
        return this.hasInputValidationErrors();
    }
}

