/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.map;

import com.daqem.uilib.api.widget.IInputValidatable;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.ButtonWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.entry.map.IMapConfigEntry;
import com.daqem.yamlconfig.api.gui.component.IComponentValidator;
import com.daqem.yamlconfig.client.gui.component.CrossButtonComponent;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;

public abstract class BaseMapConfigEntryComponent<C extends IMapConfigEntry<?>>
extends BaseConfigEntryComponent<C> {
    private static final int WIDTH = 290;
    protected final Map<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> editBoxWidgets;
    protected final ButtonWidget addEntryButton;
    protected final IComponentValidator validator;

    public BaseMapConfigEntryComponent(String key, C configEntry, IComponentValidator validator) {
        super(key, configEntry, 0, 0, BaseMapConfigEntryComponent.calculateInitialHeight(configEntry), 290);
        this.validator = validator;
        this.editBoxWidgets = this.createEditBoxWidgets(new ArrayList(new LinkedHashMap((Map)configEntry.get()).entrySet()));
        this.addEntryButton = this.createAddEntryButton();
        this.addWidgets(new ArrayList(this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.getA(), (EditBoxWidget)tuple.getB())).toList()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.addWidget((IWidget)this.addEntryButton);
    }

    private static int calculateInitialHeight(IMapConfigEntry<?> configEntry) {
        int entryCount = ((Map)configEntry.get()).size();
        return 44 + entryCount * 24;
    }

    private ButtonWidget createAddEntryButton() {
        return new ButtonWidget(0, this.getHeight() - 20, 290, 20, (Component)YamlConfig.translatable("gui.add_entry"), this::handleAddEntryButtonClick);
    }

    private void handleAddEntryButtonClick(Button clickedButton) {
        Tuple<EditBoxWidget, EditBoxWidget> newTextBoxes = this.createEditBoxWidgets(this.editBoxWidgets.size());
        CrossButtonComponent newCrossButton = this.createCrossButtonComponent(newTextBoxes);
        this.editBoxWidgets.put(newTextBoxes, newCrossButton);
        this.addWidget((IWidget)newTextBoxes.getA());
        this.addWidget((IWidget)newTextBoxes.getB());
        this.addWidget((IWidget)newCrossButton);
        this.adjustLayoutForNewEntry(clickedButton);
    }

    private Tuple<EditBoxWidget, EditBoxWidget> createEditBoxWidgets(int index) {
        return new Tuple((Object)this.createKeyEditBoxWidget(index), (Object)this.createValueEditBoxWidget(index));
    }

    private EditBoxWidget createKeyEditBoxWidget(int index) {
        return new EditBoxWidget(Minecraft.getInstance().font, 0, index * 24 + 20 + 4, 136, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List errors = super.validateInput(input);
                if (BaseMapConfigEntryComponent.this.editBoxWidgets != null) {
                    List<String> currentKeys = BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(Tuple::getA).filter(EditBoxWidget2 -> EditBoxWidget2 != this).map(EditBox::getValue).toList();
                    if (currentKeys.contains(input)) {
                        errors.add(ValidationErrors.duplicateKey());
                        BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(Tuple::getA).filter(EditBoxWidget2 -> EditBoxWidget2 != this).filter(EditBoxWidget2 -> EditBoxWidget2.getValue().equals(input)).forEach(EditBoxWidget2 -> {
                            EditBoxWidget2.setInputValidationErrors(new ArrayList(EditBoxWidget2.getInputValidationErrors()));
                            if (!EditBoxWidget2.getInputValidationErrors().contains(ValidationErrors.duplicateKey())) {
                                EditBoxWidget2.getInputValidationErrors().add(ValidationErrors.duplicateKey());
                            }
                        });
                    } else {
                        for (Map.Entry<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> entry : BaseMapConfigEntryComponent.this.editBoxWidgets.entrySet()) {
                            String key = ((EditBoxWidget)entry.getKey().getA()).getValue();
                            List<String> duplicateKeys = BaseMapConfigEntryComponent.this.editBoxWidgets.keySet().stream().map(Tuple::getA).filter(EditBoxWidget2 -> EditBoxWidget2 != this).filter(EditBoxWidget2 -> EditBoxWidget2 != ((Tuple)entry.getKey()).getA()).map(EditBox::getValue).filter(value -> value.equals(key)).toList();
                            if (!duplicateKeys.isEmpty()) continue;
                            ((EditBoxWidget)entry.getKey().getA()).setInputValidationErrors(new ArrayList<Component>(((EditBoxWidget)entry.getKey().getA()).getInputValidationErrors().stream().filter(component -> !component.equals((Object)ValidationErrors.duplicateKey())).toList()));
                        }
                    }
                }
                if (input.isEmpty()) {
                    errors.add(ValidationErrors.emptyKey());
                }
                if (!input.matches("^[a-zA-Z0-9_-]+$")) {
                    errors.add(ValidationErrors.pattern((String)"^[a-zA-Z0-9_-]+$"));
                }
                return errors;
            }
        };
    }

    private EditBoxWidget createValueEditBoxWidget(int index) {
        return new EditBoxWidget(Minecraft.getInstance().font, 140, index * 24 + 20 + 4, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                return BaseMapConfigEntryComponent.this.validator.validate(input);
            }
        };
    }

    private CrossButtonComponent createCrossButtonComponent(Tuple<EditBoxWidget, EditBoxWidget> editBoxWidgets) {
        return new CrossButtonComponent(297, ((EditBoxWidget)editBoxWidgets.getA()).getY() + 3, button -> this.handleRemoveEntryButtonClick(editBoxWidgets, (CrossButtonComponent)button));
    }

    private void handleRemoveEntryButtonClick(Tuple<EditBoxWidget, EditBoxWidget> editBoxWidgets, CrossButtonComponent crossButtonComponent) {
        this.removeEntry(editBoxWidgets, crossButtonComponent);
    }

    private void removeEntry(Tuple<EditBoxWidget, EditBoxWidget> editBoxWidgets, CrossButtonComponent crossButtonWidget) {
        this.removeWidget((IWidget)crossButtonWidget);
        this.removeWidget((IWidget)editBoxWidgets.getA());
        this.removeWidget((IWidget)editBoxWidgets.getB());
        this.editBoxWidgets.remove(editBoxWidgets);
        this.adjustLayoutForRemovedEntry();
    }

    private void adjustLayoutForNewEntry(Button addEntryButton) {
        this.setHeight(this.getHeight() + 20 + 4);
        addEntryButton.setY(this.getHeight() - 20);
    }

    private void adjustLayoutForRemovedEntry() {
        this.setHeight(this.getHeight() - 20 - 4);
        this.addEntryButton.setY(this.getHeight() - 20);
        this.updateComponentPositions();
    }

    private void updateComponentPositions() {
        int index = 0;
        for (Map.Entry<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> entry : this.editBoxWidgets.entrySet()) {
            int yPosition = index * 24 + 20 + 4;
            ((EditBoxWidget)entry.getKey().getA()).setY(yPosition);
            ((EditBoxWidget)entry.getKey().getB()).setY(yPosition);
            entry.getValue().setY(yPosition + 3);
            ++index;
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        super.render(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
        this.renderHorizontalLines(guiGraphics);
        this.addEntryButton.active = ((IMapConfigEntry)this.getConfigEntry()).getMaxLength() > this.editBoxWidgets.size();
        this.editBoxWidgets.values().forEach(crossButtonComponent -> {
            crossButtonComponent.active = ((IMapConfigEntry)this.getConfigEntry()).getMinLength() < this.editBoxWidgets.size();
        });
    }

    private void renderHorizontalLines(GuiGraphics graphics) {
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineYStart = 9 + 6;
        graphics.fill(this.getTotalX(), this.getTotalY() + lineYStart, this.getTotalX() + 290, this.getTotalY() + lineYStart + 1, -1);
    }

    @Override
    public boolean isOriginalValue() {
        List<String> currentKeyValues = this.editBoxWidgets.keySet().stream().map(Tuple::getA).map(EditBox::getValue).toList();
        List<String> originalKeyValues = ((Map)((IMapConfigEntry)this.getConfigEntry()).getDefaultValue()).keySet().stream().map(Object::toString).toList();
        List<String> currentValueValues = this.editBoxWidgets.keySet().stream().map(Tuple::getB).map(EditBox::getValue).toList();
        List<String> originalValueValues = ((Map)((IMapConfigEntry)this.getConfigEntry()).getDefaultValue()).values().stream().map(Object::toString).toList();
        return currentKeyValues.equals(originalKeyValues) && currentValueValues.equals(originalValueValues);
    }

    @Override
    public void resetValue() {
        this.clearEntries();
        this.editBoxWidgets.putAll(this.createEditBoxWidgets(new ArrayList(new LinkedHashMap((Map)((IMapConfigEntry)this.configEntry).getDefaultValue()).entrySet())));
        this.addWidgets(new ArrayList(this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.getA(), (EditBoxWidget)tuple.getB())).toList()));
        this.addWidgets(new ArrayList<CrossButtonComponent>(this.editBoxWidgets.values()));
        this.resetLayout();
    }

    private void clearEntries() {
        this.editBoxWidgets.keySet().stream().flatMap(tuple -> Stream.of((EditBoxWidget)tuple.getA(), (EditBoxWidget)tuple.getB())).forEach(arg_0 -> ((BaseMapConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.values().forEach(arg_0 -> ((BaseMapConfigEntryComponent)this).removeWidget(arg_0));
        this.editBoxWidgets.clear();
    }

    private void resetLayout() {
        int newHeight = BaseMapConfigEntryComponent.calculateInitialHeight((IMapConfigEntry)this.getConfigEntry());
        this.setHeight(newHeight);
        this.addEntryButton.setY(newHeight - 20);
    }

    private Map<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> createEditBoxWidgets(List<Map.Entry<String, ?>> configValues) {
        LinkedHashMap<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent> components = new LinkedHashMap<Tuple<EditBoxWidget, EditBoxWidget>, CrossButtonComponent>();
        for (int i = 0; i < configValues.size(); ++i) {
            EditBoxWidget keyTextBox = this.createKeyEditBoxWidget(i);
            EditBoxWidget valueTextBox = this.createValueEditBoxWidget(i);
            keyTextBox.setValue(configValues.get(i).getKey());
            valueTextBox.setValue(configValues.get(i).getValue().toString());
            Tuple tuple = new Tuple((Object)keyTextBox, (Object)valueTextBox);
            CrossButtonComponent crossButton = this.createCrossButtonComponent((Tuple<EditBoxWidget, EditBoxWidget>)tuple);
            components.put((Tuple<EditBoxWidget, EditBoxWidget>)tuple, crossButton);
        }
        return components;
    }

    public boolean hasInputValidationErrors() {
        return this.editBoxWidgets.keySet().stream().flatMap(key -> Stream.of((EditBoxWidget)key.getA(), (EditBoxWidget)key.getB())).anyMatch(IInputValidatable::hasInputValidationErrors);
    }

    @Override
    public boolean hasValidationErrors() {
        return this.hasInputValidationErrors();
    }
}

