/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.map.numeric;

import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.client.gui.component.entry.map.BaseMapConfigEntryComponent;
import com.daqem.yamlconfig.impl.config.entry.map.numeric.IntegerMapConfigEntry;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.chat.MutableComponent;

public class IntegerMapConfigEntryComponent
extends BaseMapConfigEntryComponent<IntegerMapConfigEntry> {
    public IntegerMapConfigEntryComponent(String key, IntegerMapConfigEntry configEntry) {
        super(key, configEntry, input -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            try {
                int value = Integer.parseInt(input);
                if (value < (Integer)configEntry.getMinValue()) {
                    list.add(ValidationErrors.minValue(configEntry.getMinValue()));
                }
                if (value > (Integer)configEntry.getMaxValue()) {
                    list.add(ValidationErrors.maxValue(configEntry.getMaxValue()));
                }
            }
            catch (NumberFormatException e) {
                list.add(ValidationErrors.invalidNumber());
            }
            return list;
        });
    }

    @Override
    public void applyValue() {
        if (this.hasInputValidationErrors()) {
            return;
        }
        Map<String, Integer> map = this.editBoxWidgets.keySet().stream().collect(Collectors.toMap(entry -> ((EditBoxWidget)entry.getA()).getValue(), entry -> Integer.parseInt(((EditBoxWidget)entry.getB()).getValue())));
        ((IntegerMapConfigEntry)this.getConfigEntry()).set(map);
    }
}

