/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.minecraft;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import com.daqem.yamlconfig.impl.config.entry.minecraft.RegistryConfigEntry;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RegistryConfigEntryComponent<T>
extends BaseConfigEntryComponent<RegistryConfigEntry<T>> {
    private final EditBoxWidget editBoxWidget;

    public RegistryConfigEntryComponent(String key, RegistryConfigEntry<T> configEntry) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List list = super.validateInput(input);
                ResourceLocation value = ResourceLocation.tryParse((String)input);
                if (value == null || value.getPath().isEmpty() || value.getNamespace().isEmpty() || value.getPath().contains(" ") || value.getNamespace().contains(" ")) {
                    list.add(ValidationErrors.invalidResourceLocation());
                } else if (!((RegistryConfigEntry)RegistryConfigEntryComponent.this.getConfigEntry()).getRegistry().keySet().contains(value)) {
                    list.add(ValidationErrors.invalidRegistryValue());
                }
                return list;
            }
        };
        ResourceLocation resourceLocation = ((RegistryConfigEntry)this.getConfigEntry()).getRegistry().getKey(((RegistryConfigEntry)this.getConfigEntry()).get());
        String stringValue = resourceLocation != null ? resourceLocation.toString() : "unknown";
        this.editBoxWidget.setValue(stringValue);
        this.editBoxWidget.setMaxLength(Integer.MAX_VALUE);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        Object defaultValue = ((RegistryConfigEntry)this.getConfigEntry()).getDefaultValue();
        Optional value = ((RegistryConfigEntry)this.getConfigEntry()).getRegistry().get(ResourceLocation.parse((String)this.editBoxWidget.getValue()));
        return value.isPresent() && defaultValue == ((Holder.Reference)value.get()).value();
    }

    @Override
    public void resetValue() {
        ResourceLocation resourceLocation = ((RegistryConfigEntry)this.getConfigEntry()).getRegistry().getKey(((RegistryConfigEntry)this.getConfigEntry()).getDefaultValue());
        String stringValue = resourceLocation != null ? resourceLocation.toString() : "unknown";
        this.editBoxWidget.setValue(stringValue);
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        Optional reference = ((RegistryConfigEntry)this.getConfigEntry()).getRegistry().get(ResourceLocation.parse((String)this.editBoxWidget.getValue()));
        reference.ifPresent(tReference -> ((RegistryConfigEntry)this.getConfigEntry()).set(tReference.value()));
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

