/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.client.gui.component.entry.minecraft;

import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.gui.widget.EditBoxWidget;
import com.daqem.uilib.util.ValidationErrors;
import com.daqem.yamlconfig.client.gui.component.entry.BaseConfigEntryComponent;
import com.daqem.yamlconfig.impl.config.entry.minecraft.ResourceLocationConfigEntry;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ResourceLocationConfigEntryComponent
extends BaseConfigEntryComponent<ResourceLocationConfigEntry> {
    private final EditBoxWidget editBoxWidget;

    public ResourceLocationConfigEntryComponent(String key, final ResourceLocationConfigEntry configEntry) {
        super(key, configEntry, 0, 0, 20);
        this.editBoxWidget = new EditBoxWidget(this, Minecraft.getInstance().font, 140, 0, 150, 20, (Component)Component.empty()){

            public List<Component> validateInput(String input) {
                List list = super.validateInput(input);
                ResourceLocation value = ResourceLocation.tryParse((String)input);
                if (value == null || value.getPath().isEmpty() || value.getNamespace().isEmpty() || value.getPath().contains(" ") || value.getNamespace().contains(" ")) {
                    list.add(ValidationErrors.invalidResourceLocation());
                } else if (configEntry.getPattern() != null && !input.matches(configEntry.getPattern())) {
                    list.add(ValidationErrors.pattern((String)configEntry.getPattern()));
                }
                return list;
            }
        };
        this.editBoxWidget.setValue(((ResourceLocation)configEntry.get()).toString());
        this.editBoxWidget.setMaxLength(Integer.MAX_VALUE);
        this.addWidget((IWidget)this.editBoxWidget);
    }

    @Override
    public boolean isOriginalValue() {
        return ((ResourceLocation)((ResourceLocationConfigEntry)this.getConfigEntry()).getDefaultValue()).equals((Object)ResourceLocation.tryParse((String)this.editBoxWidget.getValue()));
    }

    @Override
    public void resetValue() {
        this.editBoxWidget.setValue(((ResourceLocation)((ResourceLocationConfigEntry)this.getConfigEntry()).getDefaultValue()).toString());
    }

    @Override
    public void applyValue() {
        if (this.editBoxWidget.hasInputValidationErrors()) {
            return;
        }
        ((ResourceLocationConfigEntry)this.getConfigEntry()).set(ResourceLocation.tryParse((String)this.editBoxWidget.getValue()));
    }

    @Override
    public boolean hasValidationErrors() {
        return this.editBoxWidget.hasInputValidationErrors();
    }
}

