/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config;

import com.daqem.snakeyaml.engine.v2.api.Dump;
import com.daqem.snakeyaml.engine.v2.api.DumpSettings;
import com.daqem.snakeyaml.engine.v2.api.LoadSettings;
import com.daqem.snakeyaml.engine.v2.api.lowlevel.Compose;
import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.api.config.serializer.IConfigSerializer;
import com.daqem.yamlconfig.impl.config.ClientConfig;
import com.daqem.yamlconfig.impl.config.CommonConfig;
import com.daqem.yamlconfig.impl.config.ServerConfig;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.yaml.YamlFileWriter;
import com.mojang.datafixers.util.Function5;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;

public abstract class BaseConfig
implements IConfig {
    private final String modId;
    private final String name;
    private final ConfigExtension extension;
    private final ConfigType type;
    private final Path path;
    private final IStackConfigEntry context;
    private boolean isSynced = false;
    public static final StreamCodec<RegistryFriendlyByteBuf, BaseConfig> STREAM_CODEC = StreamCodec.of((buf, config) -> {
        buf.writeEnum((Enum)config.getType());
        buf.writeUtf(config.getModId());
        buf.writeUtf(config.getName());
        buf.writeEnum((Enum)config.getExtension());
        buf.writeUtf(config.getPath().toString());
    }, buf -> {
        ConfigType type = (ConfigType)buf.readEnum(ConfigType.class);
        String modId = buf.readUtf();
        String name = buf.readUtf();
        ConfigExtension extension = (ConfigExtension)buf.readEnum(ConfigExtension.class);
        Path path = Path.of(buf.readUtf(), new String[0]);
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConfigType.CLIENT -> new ClientConfig(modId, name, extension, path, null);
            case ConfigType.COMMON -> new CommonConfig(modId, name, extension, path, null);
            case ConfigType.SERVER -> new ServerConfig(modId, name, extension, path, null);
        };
    });

    public BaseConfig(String modId, String name, ConfigExtension extension, ConfigType type, Path path, IStackConfigEntry context) {
        this.modId = modId;
        this.name = name;
        this.extension = extension;
        this.type = type;
        this.path = path;
        this.context = context;
    }

    @Override
    public void load() {
        LoadSettings settings = LoadSettings.builder().setParseComments(true).build();
        try (FileInputStream inputStream = new FileInputStream(new File(this.path.toFile(), this.name + this.extension.getExtension()));){
            Compose compose = new Compose(settings);
            Node node = compose.composeInputStream(inputStream).orElseThrow(FileNotFoundException::new);
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                ScalarNode keyNode = new ScalarNode(Tag.STR, "parent", ScalarStyle.PLAIN);
                NodeTuple nodeTuple = new NodeTuple(keyNode, mappingNode);
                this.context.getType().getSerializer().encodeNode(this.context, nodeTuple);
            }
            this.setSynced(false);
            YamlConfig.LOGGER.info("Loaded config file: " + this.name + this.extension.getExtension());
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                YamlConfig.LOGGER.info("Creating config file: " + this.name + this.extension.getExtension());
            }
            YamlConfig.LOGGER.error("Failed to load config file: " + this.name + this.extension.getExtension(), (Throwable)e);
        }
    }

    @Override
    public void save() {
        DumpSettings settings = DumpSettings.builder().setDefaultFlowStyle(FlowStyle.BLOCK).setDumpComments(true).build();
        try {
            Dump dumper = new Dump(settings);
            YamlFileWriter streamDataWriter = new YamlFileWriter(this);
            Node node = this.context.getType().getSerializer().decodeNode(this.context).getValueNode();
            dumper.dumpNode(node, streamDataWriter);
            YamlConfig.LOGGER.info("Saved config file: " + this.name + this.extension.getExtension());
        }
        catch (FileNotFoundException e) {
            YamlConfig.LOGGER.error("Failed to save config file: " + this.name + "." + this.extension.getExtension(), (Throwable)e);
        }
    }

    @Override
    public void sync(Map<String, ?> data) {
        if (data == null) {
            return;
        }
        for (Map.Entry<String, IConfigEntry<?>> entry : this.getSyncEntries().entrySet()) {
            IConfigEntry<?> configEntry = entry.getValue();
            if (!data.containsKey(entry.getKey())) continue;
            configEntry.set(data.get(entry.getKey()));
        }
        this.setSynced(true);
    }

    @Override
    public String getModId() {
        return this.modId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigExtension getExtension() {
        return this.extension;
    }

    @Override
    public ConfigType getType() {
        return this.type;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public IStackConfigEntry getContext() {
        return this.context;
    }

    @Override
    public Map<String, IConfigEntry<?>> getEntries() {
        return this.context.getEntries();
    }

    @Override
    public Map<String, IConfigEntry<?>> getSyncEntries() {
        return this.context.getEntries().entrySet().stream().filter(entry -> ((IConfigEntry)entry.getValue()).shouldBeSynced()).collect(HashMap::new, (map, entry) -> map.put((String)entry.getKey(), (IConfigEntry)entry.getValue()), Map::putAll);
    }

    @Override
    public boolean isSynced() {
        return this.isSynced;
    }

    @Override
    public void setSynced(boolean synced) {
        this.isSynced = synced;
    }

    @Override
    public Component getDisplayName() {
        return YamlConfig.translatable(this.modId + "." + this.name);
    }

    @Override
    public Component getModName() {
        return YamlConfig.translatable(this.modId);
    }

    @Override
    public void updateEntries(Map<String, IConfigEntry<?>> entries) {
        LinkedHashMap<String, IConfigEntry<?>> existingEntries = this.context.getEntries();
        for (Map.Entry<String, IConfigEntry<?>> entry : entries.entrySet()) {
            IConfigEntry<?> existingEntry;
            if (!existingEntries.containsKey(entry.getKey()) || !(existingEntry = existingEntries.get(entry.getKey())).getType().equals(entry.getValue().getType())) continue;
            existingEntry.set(entry.getValue().get());
        }
    }

    public static class BaseConfigSerializer<T extends IConfig>
    implements IConfigSerializer<T> {
        private final Function5<String, String, ConfigExtension, Path, IStackConfigEntry, T> configConstructor;

        public BaseConfigSerializer(Function5<String, String, ConfigExtension, Path, IStackConfigEntry, T> configConstructor) {
            this.configConstructor = configConstructor;
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, T config) {
            buf.writeUtf(config.getModId());
            buf.writeUtf(config.getName());
            buf.writeEnum((Enum)config.getExtension());
            buf.writeUtf(config.getPath().toString());
            IConfigEntryType<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> type = ConfigEntryTypes.STACK;
            type.getSerializer().toNetwork(buf, config.getContext());
        }

        @Override
        public T fromNetwork(RegistryFriendlyByteBuf buf) {
            String modId = buf.readUtf();
            String name = buf.readUtf();
            ConfigExtension extension = (ConfigExtension)buf.readEnum(ConfigExtension.class);
            Path path = Path.of(buf.readUtf(), new String[0]);
            IConfigEntryType<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> type = ConfigEntryTypes.STACK;
            IStackConfigEntry context = type.getSerializer().fromNetwork(buf);
            return (T)((IConfig)this.configConstructor.apply((Object)modId, (Object)name, (Object)extension, (Object)path, (Object)context));
        }
    }
}

