/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.IStackConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.BaseConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import com.daqem.yamlconfig.registry.YamlConfigRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class StackConfigEntry
extends BaseConfigEntry<LinkedHashMap<String, IConfigEntry<?>>>
implements IStackConfigEntry {
    public StackConfigEntry(String key, LinkedHashMap<String, IConfigEntry<?>> defaultValue) {
        super(key, defaultValue);
    }

    @Override
    public void validate(LinkedHashMap<String, IConfigEntry<?>> value) {
    }

    @Override
    public IConfigEntryType<IConfigEntry<LinkedHashMap<String, IConfigEntry<?>>>, LinkedHashMap<String, IConfigEntry<?>>> getType() {
        return ConfigEntryTypes.STACK;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IStackConfigEntry, LinkedHashMap<String, IConfigEntry<?>>> {
        @Override
        public void encodeNode(IStackConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                if (configEntry.get() != null) {
                    for (Map.Entry entry : ((LinkedHashMap)configEntry.get()).entrySet()) {
                        mappingNode.getValue().stream().filter(nodeTuple1 -> {
                            ScalarNode keyNode;
                            Node patt0$temp = nodeTuple1.getKeyNode();
                            return patt0$temp instanceof ScalarNode && (keyNode = (ScalarNode)patt0$temp).getValue().equals(entry.getKey());
                        }).findFirst().ifPresent(valueNode -> ((IConfigEntry)entry.getValue()).getType().getSerializer().encodeNode((IConfigEntry)entry.getValue(), (NodeTuple)valueNode));
                    }
                }
            }
        }

        @Override
        public NodeTuple decodeNode(IStackConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode mappingNode = new MappingNode(Tag.MAP, ((LinkedHashMap)configEntry.get()).values().stream().map(configEntry1 -> configEntry1.getType().getSerializer().decodeNode(configEntry1)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, mappingNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IStackConfigEntry configEntry, LinkedHashMap<String, IConfigEntry<?>> value) {
        }

        @Override
        public LinkedHashMap<String, IConfigEntry<?>> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return null;
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IStackConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeInt(((LinkedHashMap)configEntry.getDefaultValue()).size());
            for (Map.Entry entry : ((LinkedHashMap)configEntry.getDefaultValue()).entrySet()) {
                buf.writeUtf((String)entry.getKey());
                buf.writeResourceLocation(((IConfigEntry)entry.getValue()).getType().getId());
                ((IConfigEntry)entry.getValue()).getType().getSerializer().toNetwork(buf, (IConfigEntry)entry.getValue());
            }
            buf.writeInt(((LinkedHashMap)configEntry.get()).size());
            for (Map.Entry entry : ((LinkedHashMap)configEntry.get()).entrySet()) {
                buf.writeUtf((String)entry.getKey());
                buf.writeResourceLocation(((IConfigEntry)entry.getValue()).getType().getId());
                ((IConfigEntry)entry.getValue()).getType().getSerializer().toNetwork(buf, (IConfigEntry)entry.getValue());
            }
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IStackConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            int defaultValueSize = buf.readInt();
            LinkedHashMap defaultValue = new LinkedHashMap();
            for (int i = 0; i < defaultValueSize; ++i) {
                String entryKey = buf.readUtf();
                Optional reference = YamlConfigRegistry.CONFIG_ENTRY.get(buf.readResourceLocation());
                IConfigEntryType type = reference.map(Holder.Reference::value).orElse(null);
                Object entry = Objects.requireNonNull(type).getSerializer().fromNetwork(buf);
                defaultValue.put(entryKey, (IConfigEntry<?>)entry);
            }
            int size = buf.readInt();
            LinkedHashMap value = new LinkedHashMap();
            for (int i = 0; i < size; ++i) {
                String entryKey = buf.readUtf();
                Optional reference = YamlConfigRegistry.CONFIG_ENTRY.get(buf.readResourceLocation());
                IConfigEntryType type = reference.map(Holder.Reference::value).orElse(null);
                Object entry = Objects.requireNonNull(type).getSerializer().fromNetwork(buf);
                value.put(entryKey, entry);
            }
            StackConfigEntry configEntry = new StackConfigEntry(key, defaultValue);
            configEntry.set(value);
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

