/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IFloatListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.list.numeric.BaseNumericListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class FloatListConfigEntry
extends BaseNumericListConfigEntry<Float>
implements IFloatListConfigEntry {
    public FloatListConfigEntry(String key, List<Float> value) {
        super(key, value, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatListConfigEntry(String key, List<Float> value, int minLength, int maxLength) {
        super(key, value, minLength, maxLength, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatListConfigEntry(String key, List<Float> value, int minLength, int maxLength, Float minValue, Float maxValue) {
        super(key, value, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<Float>>, List<Float>> getType() {
        return ConfigEntryTypes.FLOAT_LIST;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatListConfigEntry, List<Float>> {
        @Override
        public void encodeNode(IFloatListConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                configEntry.set(sequenceNode.getValue().stream().filter(n -> {
                    ScalarNode scalarNode;
                    return n instanceof ScalarNode && ((scalarNode = (ScalarNode)n).getTag().equals(Tag.FLOAT) || scalarNode.getTag().equals(Tag.INT));
                }).map(n -> Float.valueOf(Float.parseFloat(((ScalarNode)n).getValue()))).toList());
            }
        }

        @Override
        public NodeTuple decodeNode(IFloatListConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            SequenceNode valueNode = new SequenceNode(Tag.SEQ, ((List)configEntry.get()).stream().map(s -> new ScalarNode(Tag.FLOAT, Float.toString(s.floatValue()), ScalarStyle.PLAIN)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IFloatListConfigEntry configEntry, List<Float> value) {
            buf.writeCollection(value, FriendlyByteBuf::writeFloat);
        }

        @Override
        public List<Float> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readList(FriendlyByteBuf::readFloat);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IFloatListConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeCollection((Collection)configEntry.get(), FriendlyByteBuf::writeFloat);
            buf.writeCollection((Collection)configEntry.getDefaultValue(), FriendlyByteBuf::writeFloat);
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeFloat(((Float)configEntry.getMinValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMaxValue()).floatValue());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IFloatListConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            List value = buf.readList(FriendlyByteBuf::readFloat);
            List defaultValue = buf.readList(FriendlyByteBuf::readFloat);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            float minValue = buf.readFloat();
            float maxValue = buf.readFloat();
            FloatListConfigEntry configEntry = new FloatListConfigEntry(key, defaultValue, minLength, maxLength, Float.valueOf(minValue), Float.valueOf(maxValue));
            configEntry.set(value);
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

