/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.list.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.SequenceNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.list.numeric.IIntegerListConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.list.numeric.BaseNumericListConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class IntegerListConfigEntry
extends BaseNumericListConfigEntry<Integer>
implements IIntegerListConfigEntry {
    public IntegerListConfigEntry(String key, List<Integer> value) {
        super(key, value, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE));
    }

    public IntegerListConfigEntry(String key, List<Integer> value, int minLength, int maxLength) {
        super(key, value, minLength, maxLength, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerListConfigEntry(String key, List<Integer> value, int minLength, int maxLength, Integer minValue, Integer maxValue) {
        super(key, value, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<List<Integer>>, List<Integer>> getType() {
        return ConfigEntryTypes.INTEGER_LIST;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IIntegerListConfigEntry, List<Integer>> {
        @Override
        public void encodeNode(IIntegerListConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof SequenceNode) {
                SequenceNode sequenceNode = (SequenceNode)node;
                configEntry.set(sequenceNode.getValue().stream().filter(n -> {
                    ScalarNode scalarNode;
                    return n instanceof ScalarNode && (scalarNode = (ScalarNode)n).getTag().equals(Tag.INT);
                }).map(n -> Integer.parseInt(((ScalarNode)n).getValue())).toList());
            }
        }

        @Override
        public NodeTuple decodeNode(IIntegerListConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            SequenceNode valueNode = new SequenceNode(Tag.SEQ, ((List)configEntry.get()).stream().map(s -> new ScalarNode(Tag.INT, Integer.toString(s), ScalarStyle.PLAIN)).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IIntegerListConfigEntry configEntry, List<Integer> value) {
            buf.writeCollection(value, FriendlyByteBuf::writeInt);
        }

        @Override
        public List<Integer> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readList(FriendlyByteBuf::readInt);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IIntegerListConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeCollection((Collection)configEntry.get(), FriendlyByteBuf::writeInt);
            buf.writeCollection((Collection)configEntry.getDefaultValue(), FriendlyByteBuf::writeInt);
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeInt(((Integer)configEntry.getMinValue()).intValue());
            buf.writeInt(((Integer)configEntry.getMaxValue()).intValue());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IIntegerListConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            String key = buf.readUtf();
            List value = buf.readList(FriendlyByteBuf::readInt);
            List defaultValue = buf.readList(FriendlyByteBuf::readInt);
            int minLength = buf.readInt();
            int maxLength = buf.readInt();
            int minValue = buf.readInt();
            int maxValue = buf.readInt();
            IntegerListConfigEntry configEntry = new IntegerListConfigEntry(key, defaultValue, minLength, maxLength, minValue, maxValue);
            configEntry.set(value);
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

