/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.map.numeric;

import com.daqem.yamlconfig.api.config.entry.comment.IComments;
import com.daqem.yamlconfig.api.config.entry.map.numeric.INumericMapConfigEntry;
import com.daqem.yamlconfig.api.exception.ConfigEntryValidationException;
import com.daqem.yamlconfig.impl.config.entry.map.BaseMapConfigEntry;
import java.util.Map;

public abstract class BaseNumericMapConfigEntry<T extends Number>
extends BaseMapConfigEntry<T>
implements INumericMapConfigEntry<T> {
    private final T minValue;
    private final T maxValue;

    public BaseNumericMapConfigEntry(String key, Map<String, T> defaultValue, T minValue, T maxValue) {
        this(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, minValue, maxValue);
    }

    public BaseNumericMapConfigEntry(String key, Map<String, T> defaultValue, int minLength, int maxLength, T minValue, T maxValue) {
        super(key, defaultValue, minLength, maxLength);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }

    @Override
    public void validate(Map<String, T> value) throws ConfigEntryValidationException {
        super.validate(value);
        for (Map.Entry<String, T> entry : value.entrySet()) {
            Number element = (Number)entry.getValue();
            if ((this.minValue == null || ((Comparable)((Object)element)).compareTo(this.minValue) >= 0) && (this.maxValue == null || ((Comparable)((Object)element)).compareTo(this.maxValue) <= 0)) continue;
            throw new ConfigEntryValidationException(this.getKey() + "." + entry.getKey(), "Element is out of bounds. Expected between " + String.valueOf(this.minValue) + " and " + String.valueOf(this.maxValue));
        }
    }

    @Override
    public IComments getComments() {
        IComments comments = super.getComments();
        if (comments.showValidationParameters()) {
            if (this.minValue != null) {
                comments.addValidationParameter("Minimum value: " + String.valueOf(this.minValue));
            }
            if (this.maxValue != null) {
                comments.addValidationParameter("Maximum value: " + String.valueOf(this.maxValue));
            }
        }
        comments.addDefaultValues(((Map)this.getDefaultValue()).toString());
        return comments;
    }
}

