/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.map.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.map.numeric.IFloatMapConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.map.numeric.BaseNumericMapConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class FloatMapConfigEntry
extends BaseNumericMapConfigEntry<Float>
implements IFloatMapConfigEntry {
    public FloatMapConfigEntry(String key, Map<String, Float> defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatMapConfigEntry(String key, Map<String, Float> defaultValue, int minLength, int maxLength) {
        super(key, defaultValue, minLength, maxLength, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatMapConfigEntry(String key, Map<String, Float> defaultValue, int minLength, int maxLength, Float minValue, Float maxValue) {
        super(key, defaultValue, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Map<String, Float>>, Map<String, Float>> getType() {
        return ConfigEntryTypes.FLOAT_MAP;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatMapConfigEntry, Map<String, Float>> {
        @Override
        public void encodeNode(IFloatMapConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                configEntry.set(mappingNode.getValue().stream().filter(n -> {
                    Node patt0$temp = n.getKeyNode();
                    if (!(patt0$temp instanceof ScalarNode)) return false;
                    ScalarNode keyNode = (ScalarNode)patt0$temp;
                    Node patt1$temp = n.getValueNode();
                    if (!(patt1$temp instanceof ScalarNode)) return false;
                    ScalarNode valueNode = (ScalarNode)patt1$temp;
                    if (!keyNode.getTag().equals(Tag.STR)) return false;
                    if (valueNode.getTag().equals(Tag.FLOAT)) return true;
                    if (!valueNode.getTag().equals(Tag.INT)) return false;
                    return true;
                }).collect(Collectors.toMap(n -> ((ScalarNode)n.getKeyNode()).getValue(), n -> Float.valueOf(Float.parseFloat(((ScalarNode)n.getValueNode()).getValue())))));
            }
        }

        @Override
        public NodeTuple decodeNode(IFloatMapConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode valueNode = new MappingNode(Tag.MAP, ((Map)configEntry.get()).entrySet().stream().map(e -> new NodeTuple(new ScalarNode(Tag.STR, (String)e.getKey(), ScalarStyle.PLAIN), new ScalarNode(Tag.FLOAT, ((Float)e.getValue()).toString(), ScalarStyle.PLAIN))).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IFloatMapConfigEntry configEntry, Map<String, Float> value) {
            buf.writeMap(value, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeFloat);
        }

        @Override
        public Map<String, Float> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readFloat);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IFloatMapConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeMap((Map)configEntry.getDefaultValue(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeFloat);
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeFloat(((Float)configEntry.getMinValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMaxValue()).floatValue());
            buf.writeMap((Map)configEntry.get(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeFloat);
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IFloatMapConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            FloatMapConfigEntry configEntry = new FloatMapConfigEntry(buf.readUtf(), buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readFloat), buf.readInt(), buf.readInt(), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()));
            configEntry.set(buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readFloat));
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

