/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.map.numeric;

import com.daqem.snakeyaml.engine.v2.common.FlowStyle;
import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.MappingNode;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.map.numeric.IIntegerMapConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.map.numeric.BaseNumericMapConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class IntegerMapConfigEntry
extends BaseNumericMapConfigEntry<Integer>
implements IIntegerMapConfigEntry {
    public IntegerMapConfigEntry(String key, Map<String, Integer> defaultValue) {
        super(key, defaultValue, Integer.valueOf(Integer.MIN_VALUE), Integer.valueOf(Integer.MAX_VALUE));
    }

    public IntegerMapConfigEntry(String key, Map<String, Integer> defaultValue, int minLength, int maxLength) {
        super(key, defaultValue, minLength, maxLength, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public IntegerMapConfigEntry(String key, Map<String, Integer> defaultValue, int minLength, int maxLength, Integer minValue, Integer maxValue) {
        super(key, defaultValue, minLength, maxLength, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Map<String, Integer>>, Map<String, Integer>> getType() {
        return ConfigEntryTypes.INTEGER_MAP;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IIntegerMapConfigEntry, Map<String, Integer>> {
        @Override
        public void encodeNode(IIntegerMapConfigEntry configEntry, NodeTuple nodeTuple) {
            Node node = nodeTuple.getValueNode();
            if (node instanceof MappingNode) {
                MappingNode mappingNode = (MappingNode)node;
                configEntry.set(mappingNode.getValue().stream().filter(n -> {
                    Node patt0$temp = n.getKeyNode();
                    if (!(patt0$temp instanceof ScalarNode)) return false;
                    ScalarNode keyNode = (ScalarNode)patt0$temp;
                    Node patt1$temp = n.getValueNode();
                    if (!(patt1$temp instanceof ScalarNode)) return false;
                    ScalarNode valueNode = (ScalarNode)patt1$temp;
                    if (!keyNode.getTag().equals(Tag.STR)) return false;
                    if (!valueNode.getTag().equals(Tag.INT)) return false;
                    return true;
                }).collect(Collectors.toMap(n -> ((ScalarNode)n.getKeyNode()).getValue(), n -> Integer.parseInt(((ScalarNode)n.getValueNode()).getValue()))));
            }
        }

        @Override
        public NodeTuple decodeNode(IIntegerMapConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            MappingNode valueNode = new MappingNode(Tag.MAP, ((Map)configEntry.get()).entrySet().stream().map(e -> {
                ScalarNode key = new ScalarNode(Tag.STR, (String)e.getKey(), ScalarStyle.PLAIN);
                ScalarNode value = new ScalarNode(Tag.INT, Integer.toString((Integer)e.getValue()), ScalarStyle.PLAIN);
                return new NodeTuple(key, value);
            }).toList(), FlowStyle.BLOCK);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IIntegerMapConfigEntry configEntry, Map<String, Integer> value) {
            buf.writeMap(value, FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
        }

        @Override
        public Map<String, Integer> valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt);
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IIntegerMapConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeMap((Map)configEntry.getDefaultValue(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
            buf.writeInt(configEntry.getMinLength());
            buf.writeInt(configEntry.getMaxLength());
            buf.writeInt(((Integer)configEntry.getMinValue()).intValue());
            buf.writeInt(((Integer)configEntry.getMaxValue()).intValue());
            buf.writeMap((Map)configEntry.get(), FriendlyByteBuf::writeUtf, FriendlyByteBuf::writeInt);
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IIntegerMapConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            IntegerMapConfigEntry configEntry = new IntegerMapConfigEntry(buf.readUtf(), buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt());
            configEntry.set(buf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readInt));
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

