/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IDoubleConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class DoubleConfigEntry
extends BaseNumericConfigEntry<Double>
implements IDoubleConfigEntry {
    public DoubleConfigEntry(String key, Double defaultValue) {
        super(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public DoubleConfigEntry(String key, Double defaultValue, Double minValue, Double maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Double>, Double> getType() {
        return ConfigEntryTypes.DOUBLE;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IDoubleConfigEntry, Double> {
        @Override
        public void encodeNode(IDoubleConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.FLOAT)) {
                configEntry.set(Double.parseDouble(scalarNode.getValue()));
            }
        }

        @Override
        public NodeTuple decodeNode(IDoubleConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.FLOAT, Double.toString((Double)configEntry.get()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IDoubleConfigEntry configEntry, Double value) {
            buf.writeDouble(value.doubleValue());
        }

        @Override
        public Double valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IDoubleConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeDouble(((Double)configEntry.getDefaultValue()).doubleValue());
            buf.writeDouble(((Double)configEntry.getMinValue()).doubleValue());
            buf.writeDouble(((Double)configEntry.getMaxValue()).doubleValue());
            buf.writeDouble(((Double)configEntry.get()).doubleValue());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IDoubleConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            DoubleConfigEntry configEntry = new DoubleConfigEntry(buf.readUtf(), buf.readDouble(), buf.readDouble(), buf.readDouble());
            configEntry.set(buf.readDouble());
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

