/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.impl.config.entry.numeric;

import com.daqem.snakeyaml.engine.v2.common.ScalarStyle;
import com.daqem.snakeyaml.engine.v2.nodes.Node;
import com.daqem.snakeyaml.engine.v2.nodes.NodeTuple;
import com.daqem.snakeyaml.engine.v2.nodes.ScalarNode;
import com.daqem.snakeyaml.engine.v2.nodes.Tag;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.api.config.entry.numeric.IFloatConfigEntry;
import com.daqem.yamlconfig.api.config.entry.serializer.IConfigEntrySerializer;
import com.daqem.yamlconfig.api.config.entry.type.IConfigEntryType;
import com.daqem.yamlconfig.impl.config.entry.numeric.BaseNumericConfigEntry;
import com.daqem.yamlconfig.impl.config.entry.type.ConfigEntryTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;

public class FloatConfigEntry
extends BaseNumericConfigEntry<Float>
implements IFloatConfigEntry {
    public FloatConfigEntry(String key, Float defaultValue) {
        super(key, defaultValue, Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
    }

    public FloatConfigEntry(String key, Float defaultValue, Float minValue, Float maxValue) {
        super(key, defaultValue, minValue, maxValue);
    }

    @Override
    public IConfigEntryType<IConfigEntry<Float>, Float> getType() {
        return ConfigEntryTypes.FLOAT;
    }

    public static class Serializer
    implements IConfigEntrySerializer<IFloatConfigEntry, Float> {
        @Override
        public void encodeNode(IFloatConfigEntry configEntry, NodeTuple nodeTuple) {
            ScalarNode scalarNode;
            Node node = nodeTuple.getValueNode();
            if (node instanceof ScalarNode && (scalarNode = (ScalarNode)node).getTag().equals(Tag.FLOAT)) {
                configEntry.set(Float.valueOf(Float.parseFloat(scalarNode.getValue())));
            }
        }

        @Override
        public NodeTuple decodeNode(IFloatConfigEntry configEntry) {
            ScalarNode keyNode = configEntry.createKeyNode();
            ScalarNode valueNode = new ScalarNode(Tag.FLOAT, Float.toString(((Float)configEntry.get()).floatValue()), ScalarStyle.PLAIN);
            return new NodeTuple(keyNode, valueNode);
        }

        @Override
        public void valueToNetwork(RegistryFriendlyByteBuf buf, IFloatConfigEntry configEntry, Float value) {
            buf.writeFloat(value.floatValue());
        }

        @Override
        public Float valueFromNetwork(RegistryFriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public void toNetwork(RegistryFriendlyByteBuf buf, IFloatConfigEntry configEntry) {
            buf.writeUtf(configEntry.getKey());
            buf.writeFloat(((Float)configEntry.getDefaultValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMinValue()).floatValue());
            buf.writeFloat(((Float)configEntry.getMaxValue()).floatValue());
            buf.writeFloat(((Float)configEntry.get()).floatValue());
            buf.writeCollection(configEntry.getComments().getComments(false), FriendlyByteBuf::writeUtf);
        }

        @Override
        public IFloatConfigEntry fromNetwork(RegistryFriendlyByteBuf buf) {
            FloatConfigEntry configEntry = new FloatConfigEntry(buf.readUtf(), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()), Float.valueOf(buf.readFloat()));
            configEntry.set(Float.valueOf(buf.readFloat()));
            buf.readList(FriendlyByteBuf::readUtf).forEach(configEntry.getComments()::addComment);
            return configEntry;
        }
    }
}

