/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.networking;

import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.client.networking.ClientboundOpenConfigScreenPacketHandler;
import com.daqem.yamlconfig.client.networking.ClientboundOpenConfigsScreenPacketHandler;
import com.daqem.yamlconfig.client.networking.ClientboundSyncConfigPacketHandler;
import com.daqem.yamlconfig.networking.c2s.ServerboundOpenConfigScreenPacket;
import com.daqem.yamlconfig.networking.c2s.ServerboundOpenConfigsScreenPacket;
import com.daqem.yamlconfig.networking.c2s.ServerboundSaveConfigPacket;
import com.daqem.yamlconfig.networking.s2c.ClientboundOpenConfigScreenPacket;
import com.daqem.yamlconfig.networking.s2c.ClientboundOpenConfigsScreenPacket;
import com.daqem.yamlconfig.networking.s2c.ClientboundSyncConfigPacket;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public interface YamlConfigNetworking {
    public static final CustomPacketPayload.Type<ClientboundSyncConfigPacket> CLIENTBOUND_SYNC_CONFIG = new CustomPacketPayload.Type(YamlConfig.getId("clientbound_sync_config"));
    public static final CustomPacketPayload.Type<ClientboundOpenConfigsScreenPacket> CLIENTBOUND_OPEN_CONFIGS_SCREEN_PACKET = new CustomPacketPayload.Type(YamlConfig.getId("clientbound_open_configs_screen_packet"));
    public static final CustomPacketPayload.Type<ClientboundOpenConfigScreenPacket> CLIENTBOUND_OPEN_CONFIG_SCREEN_PACKET = new CustomPacketPayload.Type(YamlConfig.getId("clientbound_open_config_screen_packet"));
    public static final CustomPacketPayload.Type<ServerboundOpenConfigsScreenPacket> SERVERBOUND_OPEN_CONFIGS_SCREEN_PACKET = new CustomPacketPayload.Type(YamlConfig.getId("serverbound_open_configs_screen_packet"));
    public static final CustomPacketPayload.Type<ServerboundOpenConfigScreenPacket> SERVERBOUND_OPEN_CONFIG_SCREEN_PACKET = new CustomPacketPayload.Type(YamlConfig.getId("serverbound_open_config_screen_packet"));
    public static final CustomPacketPayload.Type<ServerboundSaveConfigPacket> SERVERBOUND_SAVE_CONFIG_PACKET = new CustomPacketPayload.Type(YamlConfig.getId("serverbound_save_config_packet"));

    public static void initClient() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_SYNC_CONFIG, ClientboundSyncConfigPacket.STREAM_CODEC, ClientboundSyncConfigPacketHandler::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_OPEN_CONFIGS_SCREEN_PACKET, ClientboundOpenConfigsScreenPacket.STREAM_CODEC, ClientboundOpenConfigsScreenPacketHandler::handleClientSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, CLIENTBOUND_OPEN_CONFIG_SCREEN_PACKET, ClientboundOpenConfigScreenPacket.STREAM_CODEC, ClientboundOpenConfigScreenPacketHandler::handleClientSide);
    }

    public static void initServer() {
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_SYNC_CONFIG, ClientboundSyncConfigPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_OPEN_CONFIGS_SCREEN_PACKET, ClientboundOpenConfigsScreenPacket.STREAM_CODEC);
        NetworkManager.registerS2CPayloadType(CLIENTBOUND_OPEN_CONFIG_SCREEN_PACKET, ClientboundOpenConfigScreenPacket.STREAM_CODEC);
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> YamlConfigNetworking::initClient);
        EnvExecutor.runInEnv((Env)Env.SERVER, () -> YamlConfigNetworking::initServer);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SERVERBOUND_OPEN_CONFIGS_SCREEN_PACKET, ServerboundOpenConfigsScreenPacket.STREAM_CODEC, ServerboundOpenConfigsScreenPacket::handleServerSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SERVERBOUND_OPEN_CONFIG_SCREEN_PACKET, ServerboundOpenConfigScreenPacket.STREAM_CODEC, ServerboundOpenConfigScreenPacket::handleServerSide);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, SERVERBOUND_SAVE_CONFIG_PACKET, ServerboundSaveConfigPacket.STREAM_CODEC, ServerboundSaveConfigPacket::handleServerSide);
    }
}

