/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.networking.c2s;

import com.daqem.yamlconfig.YamlConfig;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.networking.YamlConfigNetworking;
import com.daqem.yamlconfig.networking.s2c.ClientboundSyncConfigPacket;
import dev.architectury.networking.NetworkManager;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class ServerboundSaveConfigPacket
implements CustomPacketPayload {
    private final IConfig config;
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerboundSaveConfigPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeEnum((Enum)packet.config.getType());
        packet.config.getType().getSerializer().toNetwork((RegistryFriendlyByteBuf)buf, packet.config);
    }, buf -> {
        ConfigType type = (ConfigType)buf.readEnum(ConfigType.class);
        IConfig config = type.getSerializer().fromNetwork((RegistryFriendlyByteBuf)buf);
        return new ServerboundSaveConfigPacket(config);
    });

    public ServerboundSaveConfigPacket(IConfig config) {
        this.config = config;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return YamlConfigNetworking.SERVERBOUND_SAVE_CONFIG_PACKET;
    }

    public void handleServerSide(NetworkManager.PacketContext packetContext) {
        if (packetContext.getPlayer().hasPermissions(2)) {
            IConfig existingConfig = YamlConfig.CONFIG_MANAGER.getConfig(this.config.getModId(), this.config.getName());
            existingConfig.updateEntries(this.config.getEntries());
            existingConfig.save();
            if (existingConfig.getType() == ConfigType.COMMON) {
                Objects.requireNonNull(packetContext.getPlayer().getServer()).getPlayerList().getPlayers().forEach(player -> NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientboundSyncConfigPacket(existingConfig)));
            }
        }
    }
}

