/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.yamlconfig.test;

import com.daqem.yamlconfig.api.config.ConfigExtension;
import com.daqem.yamlconfig.api.config.ConfigType;
import com.daqem.yamlconfig.api.config.IConfig;
import com.daqem.yamlconfig.api.config.entry.IConfigEntry;
import com.daqem.yamlconfig.impl.config.ConfigBuilder;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class CommonTestConfig {
    public static IConfig config;
    public static IConfigEntry<Boolean> debug;
    public static IConfigEntry<Integer> testInt;
    public static IConfigEntry<String> testString;
    public static IConfigEntry<String> testString1;
    public static IConfigEntry<List<String>> testStringList;
    public static IConfigEntry<List<Integer>> testIntList;
    public static IConfigEntry<Boolean> testBoolean;
    public static IConfigEntry<Float> testFloat;
    public static IConfigEntry<Double> testDouble;
    public static IConfigEntry<Difficulty> testEnum;
    public static IConfigEntry<Map<String, Integer>> testIntegerMap;
    public static IConfigEntry<LocalDateTime> testDateTime;
    public static IConfigEntry<Item> testItem;
    public static IConfigEntry<ResourceLocation> testResourceLocation;

    public static void init() {
        ConfigBuilder builder = new ConfigBuilder("test", "test-common", ConfigExtension.YAML, ConfigType.COMMON);
        debug = builder.defineBoolean("debug", false).withComments("Whether debug mode is enabled for the mod.").dontSync();
        builder.push("test").withComments("This is a test stack.", "And another comment.", "Wow even a third comment.");
        testInt = builder.defineInteger("testInt", 10, 0, 100);
        builder.push("test1");
        testString = builder.defineString("testString", "test");
        builder.push("test2");
        testString1 = builder.defineString("testString", "test");
        builder.pop();
        builder.pop();
        builder.pop();
        testStringList = builder.defineStringList("testStringList", List.of("test1", "test2", "test3"), 3, 10, "test\\d+");
        testIntList = builder.defineIntegerList("testIntList", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), 3, 10);
        testBoolean = builder.defineBoolean("testBoolean", true);
        testFloat = builder.defineFloat("testFloat", 1.0f);
        testDouble = builder.defineDouble("testDouble", 1.0);
        testEnum = builder.defineEnum("testEnum", Difficulty.NORMAL, Difficulty.class);
        testIntegerMap = builder.defineIntegerMap("testIntegerMap", Map.of("test1", 1, "test2", 2, "test3", 3), 3, 10);
        testDateTime = builder.defineDateTime("testDateTime", LocalDateTime.of(2021, 1, 1, 0, 0, 0));
        testItem = builder.defineRegistry("testItem", Items.STONE, BuiltInRegistries.ITEM);
        testResourceLocation = builder.defineResourceLocation("testResourceLocation", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone"));
        config = builder.build();
        ConfigBuilder builder4 = new ConfigBuilder("test1", "test1-common", ConfigExtension.YAML, ConfigType.COMMON);
        builder4.push("mod_config");
        builder4.push("general");
        builder4.defineString("mod_name", "Test Mod");
        builder4.defineString("mod_version", "1.0.0");
        builder4.defineString("mod_author", "Test Author");
        builder4.pop();
        builder4.push("items");
        builder4.defineRegistry("item", Items.GRASS_BLOCK, BuiltInRegistries.ITEM);
        builder4.defineRegistry("block", Blocks.GRASS_BLOCK, BuiltInRegistries.BLOCK);
        builder4.defineString("custom_name", "Grass Block");
        builder4.defineInteger("max_stack_size", 64, 1, 64);
        builder4.pop();
        builder4.push("settings");
        builder4.defineInteger("integer_entry", 10, 0, 100);
        builder4.defineFloat("float_entry", 1.0f, 0.0f, 1.0f);
        builder4.defineDouble("double_entry", 1.0, 0.0, 1.0);
        builder4.defineResourceLocation("resource_location_entry", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"stone"));
        builder4.defineEnum("enum_entry", Difficulty.NORMAL, Difficulty.class);
        builder4.defineDateTime("date_time_entry", LocalDateTime.of(2021, 1, 1, 0, 0, 0));
        builder4.pop();
        builder4.push("lists");
        builder4.defineStringList("string_list", List.of("test1", "test2", "test3"), 3, 10, "test\\d+");
        builder4.defineIntegerList("integer_list", List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), 3, 10);
        builder4.defineFloatList("float_list", List.of(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), 3, 10);
        builder4.defineDoubleList("double_list", List.of(Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0)), 3, 10);
        builder4.pop();
        builder4.pop();
        builder4.push("test");
        builder4.push("maps");
        builder4.defineStringMap("string_map", Map.of("test1", "1", "test2", "2", "test3", "3"), 3, 10);
        builder4.defineIntegerMap("integer_map", Map.of("test1", 1, "test2", 2, "test3", 3), 3, 10);
        builder4.defineFloatMap("float_map", Map.of("test1", Float.valueOf(1.0f), "test2", Float.valueOf(2.0f), "test3", Float.valueOf(3.0f)), 3, 10);
        builder4.defineDoubleMap("double_map", Map.of("test1", 1.0, "test2", 2.0, "test3", 3.0), 3, 10);
        builder4.pop();
        builder4.pop();
        builder4.build();
        ConfigBuilder builder5 = new ConfigBuilder("test2", "test2-common", ConfigExtension.YAML, ConfigType.COMMON);
        builder5.defineString("test", "value");
        builder5.defineString("test1", "value1");
        builder5.defineString("test2", "value2");
        builder5.defineString("test3", "value3");
        builder5.defineString("test4", "value4");
        builder5.defineStringMap("string_map", Map.of("test1", "1"), 0, 10);
        builder5.defineStringList("string_list", List.of("test1", "test2", "test3"), 3, 10, "test\\d+");
        builder5.build();
    }
}

