/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui;

import com.daqem.uilib.api.background.IBackground;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.screen.IScreen;
import com.daqem.uilib.api.screen.IScreenAccessor;
import com.daqem.uilib.api.widget.IWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractScreen
extends Screen
implements IScreen {
    @Nullable
    private IBackground background;
    private final IScreenAccessor screenAccessor = this instanceof IScreenAccessor ? (IScreenAccessor)((Object)this) : null;

    public AbstractScreen(Component title) {
        super(title);
    }

    @Override
    @NotNull
    public List<? extends GuiEventListener> children() {
        List widgets = super.children();
        if (this.screenAccessor != null) {
            ArrayList<IWidget> combined = new ArrayList<IWidget>(widgets);
            for (Renderable renderable : this.screenAccessor.uilib$getRenderables()) {
                if (!(renderable instanceof IComponent)) continue;
                IComponent component = (IComponent)renderable;
                combined.addAll(component.getAllWidgets());
            }
            return List.copyOf(combined);
        }
        return widgets;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.background != null) {
            this.background.render(guiGraphics, mouseX, mouseY, partialTick);
        } else {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    @Nullable
    public IBackground getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(@Nullable IBackground background) {
        this.background = background;
    }

    @Override
    public void clearBackground() {
        this.background = null;
    }

    @Override
    public List<IComponent> getComponents() {
        return this.screenAccessor != null ? this.screenAccessor.uilib$getRenderables().stream().filter(renderable -> renderable instanceof IComponent).map(renderable -> (IComponent)renderable).toList() : List.of();
    }

    @Override
    public void addComponent(IComponent component) {
        this.addRenderableOnly(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        for (IComponent iComponent : components) {
            this.addRenderableOnly(iComponent);
        }
    }

    @Override
    public void removeComponent(IComponent component) {
        if (this.screenAccessor != null) {
            this.screenAccessor.uilib$getRenderables().remove(component);
        }
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        if (this.screenAccessor != null) {
            for (IComponent iComponent : components) {
                this.screenAccessor.uilib$getRenderables().remove(iComponent);
            }
        }
    }

    @Override
    public void clearComponents() {
        if (this.screenAccessor != null) {
            this.screenAccessor.uilib$getRenderables().clear();
        }
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.children().stream().filter(guiEventListener -> guiEventListener instanceof IWidget).map(guiEventListener -> (IWidget)guiEventListener).toList();
    }

    @Override
    public void addWidget(IWidget widget) {
        super.addRenderableWidget((GuiEventListener)widget);
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        for (IWidget iWidget : widgets) {
            this.addRenderableWidget(iWidget);
        }
    }

    @Override
    public void removeWidget(IWidget widget) {
        if (this.screenAccessor != null) {
            this.screenAccessor.uilib$removeWidget(widget);
        }
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        if (this.screenAccessor != null) {
            for (IWidget iWidget : widgets) {
                this.screenAccessor.uilib$removeWidget(iWidget);
            }
        }
    }

    @Override
    public void clearOnlyWidgets() {
        if (this.screenAccessor != null) {
            this.screenAccessor.uilib$getRenderables().removeIf(renderable -> renderable instanceof IWidget);
            this.screenAccessor.uilib$getChildren().removeIf(renderable -> renderable instanceof IWidget);
            this.screenAccessor.uilib$getNarratables().removeIf(renderable -> renderable instanceof IWidget);
        }
    }

    @Override
    public void clear() {
        if (this.screenAccessor != null) {
            this.screenAccessor.uilib$getRenderables().clear();
            this.screenAccessor.uilib$getChildren().clear();
            this.screenAccessor.uilib$getNarratables().clear();
        }
    }

    protected void init() {
        super.init();
        if (this.screenAccessor != null) {
            for (Renderable uilib$getRenderable : this.screenAccessor.uilib$getRenderables()) {
                if (uilib$getRenderable instanceof IComponent) {
                    IComponent component = (IComponent)uilib$getRenderable;
                    component.updateParentPosition(0, 0, this.width, this.height);
                }
                if (!(uilib$getRenderable instanceof IWidget)) continue;
                IWidget widget = (IWidget)uilib$getRenderable;
                widget.uilib$updateParentPosition(0, 0);
            }
        }
    }
}

