/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.skilltree;

import com.daqem.uilib.api.skilltree.ISkillTree;
import com.daqem.uilib.api.skilltree.ISkillTreeItem;
import com.daqem.uilib.api.widget.skilltree.ISkillTreeItemWidget;
import com.daqem.uilib.gui.component.EmptyComponent;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.layouts.LayoutElement;

public class SkillTreeMovingComponent
extends EmptyComponent {
    private final ISkillTree skillTree;
    private final List<ISkillTreeItemWidget> itemWidgets;
    private final Map<ISkillTreeItem, ISkillTreeItemWidget> itemWidgetsMap;

    public SkillTreeMovingComponent(ISkillTree skillTree) {
        super(0, 0, 0, 0);
        this.skillTree = skillTree;
        this.itemWidgets = skillTree.getItems().stream().map(item -> {
            ISkillTreeItemWidget itemWidget = item.createWidget();
            itemWidget.setX((int)((float)skillTree.getHorizontalMargin() + item.getX() * (float)(skillTree.getSkillTreeItemWidth() + skillTree.getHorizontalSpacing())));
            itemWidget.setY((int)((float)skillTree.getVerticalMargin() + item.getY() * (float)(skillTree.getSkillTreeItemHeight() + skillTree.getVerticalSpacing())));
            return itemWidget;
        }).toList();
        this.itemWidgetsMap = this.itemWidgets.stream().collect(Collectors.toMap(ISkillTreeItemWidget::getSkillTreeItem, item -> item));
        this.setWidth(this.itemWidgets.stream().mapToInt(LayoutElement::getX).max().orElse(0) + skillTree.getSkillTreeItemWidth() + skillTree.getHorizontalMargin());
        this.setHeight(this.itemWidgets.stream().mapToInt(LayoutElement::getY).max().orElse(0) + skillTree.getSkillTreeItemHeight() + skillTree.getVerticalMargin());
        this.addWidgets(this.itemWidgets);
    }

    public void setXOffset(int xOffset) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            itemWidget.setX(itemWidget.getX() + xOffset);
        }
    }

    public void setYOffset(int yOffset) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            itemWidget.setY(itemWidget.getY() + yOffset);
        }
    }

    @Override
    public void renderBase(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        this.renderConnections(guiGraphics);
        super.renderBase(guiGraphics, mouseX, mouseY, partialTick, parentWidth, parentHeight);
    }

    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            if (!itemWidget.isMouseOver(mouseX, mouseY)) continue;
            itemWidget.renderTooltips(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderConnections(GuiGraphics guiGraphics) {
        for (ISkillTreeItemWidget itemWidget : this.itemWidgets) {
            if (itemWidget.getSkillTreeItem() == this.skillTree.getRoot()) continue;
            ISkillTreeItemWidget parent = this.itemWidgetsMap.get(itemWidget.getSkillTreeItem().getParent());
            int parentX = parent.getX() + parent.getWidth() / 2;
            int parentY = parent.getY() + parent.getHeight() / 2;
            int childX = itemWidget.getX() + itemWidget.getWidth() / 2;
            int childY = itemWidget.getY() + itemWidget.getHeight() / 2;
            if (parentY == childY) {
                guiGraphics.hLine(parentX, childX, parentY - 1, -16777216);
                guiGraphics.hLine(parentX, childX, parentY + 1, -16777216);
                guiGraphics.hLine(parentX, childX, parentY, -1);
                continue;
            }
            int midX = (parentX + childX) / 2;
            guiGraphics.fill(parentX, parentY - 1, midX, parentY + 2, -16777216);
            guiGraphics.fill(midX - 1, parentY, midX + 2, childY, -16777216);
            guiGraphics.fill(midX - 1, childY - 1, childX + 1, childY + 2, -16777216);
            guiGraphics.hLine(parentX, midX, parentY, -1);
            guiGraphics.vLine(midX, parentY, childY, -1);
            guiGraphics.hLine(midX, childX, childY, -1);
        }
    }
}

