/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.AbstractComponent;
import com.daqem.uilib.gui.component.text.TextAlign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;

public abstract class AbstractTextComponent
extends AbstractComponent {
    private Component text;
    private int color;
    private boolean drawShadow = false;
    private TextAlign textAlign = TextAlign.LEFT;
    private Font font;

    public AbstractTextComponent(int x, int y, int width, int height, Component text) {
        this(x, y, width, height, text, -1);
    }

    public AbstractTextComponent(int x, int y, int width, int height, Component text, int color) {
        super(x, y, width, height);
        this.font = Minecraft.getInstance().font;
        this.text = text;
        this.color = color;
    }

    @Override
    public int getTotalX() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return super.getTotalX() - this.getWidth() / 2;
            }
            case RIGHT: {
                return super.getTotalX() - this.getWidth();
            }
            case LEFT: {
                return super.getTotalX();
            }
        }
        return super.getTotalX();
    }

    public Component getText() {
        return this.text;
    }

    public void setText(Component text) {
        this.text = text;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean isDrawShadow() {
        return this.drawShadow;
    }

    public void setDrawShadow(boolean drawShadow) {
        this.drawShadow = drawShadow;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

