/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.text.AbstractSingleLineTextComponent;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ScrollingTextComponent
extends AbstractSingleLineTextComponent {
    private int maxWidth;

    public ScrollingTextComponent(int x, int y, int maxWidth, Component text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
    }

    public ScrollingTextComponent(int x, int y, int maxWidth, Component text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        if (this.getWidth() > this.maxWidth) {
            guiGraphics.enableScissor(this.getTotalX() + this.getXOffset(), this.getTotalY(), this.getTotalX() + this.maxWidth + this.getXOffset(), this.getTotalY() + this.getHeight());
            int hiddenWidth = this.getWidth() - this.maxWidth;
            double currentTimeSeconds = (double)Util.getMillis() / 1000.0;
            double animationDuration = Math.max((double)hiddenWidth * 0.5, 3.0);
            double animationFactor = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * currentTimeSeconds / animationDuration)) / 2.0 + 0.5;
            double scrollOffset = Mth.lerp((double)animationFactor, (double)0.0, (double)hiddenWidth);
            this.drawText(guiGraphics, (int)scrollOffset - this.getXOffset());
            guiGraphics.disableScissor();
        } else {
            this.drawText(guiGraphics, 0);
        }
        if (this.isRenderDebugBorder()) {
            guiGraphics.hLine(this.getTotalX() + this.getXOffset(), this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY(), -16776961);
            guiGraphics.vLine(this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.hLine(this.getTotalX() + this.getXOffset(), this.getTotalX() + this.maxWidth + this.getXOffset() - 1, this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.vLine(this.getTotalX() + this.getXOffset(), this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
        }
    }

    protected int getXOffset() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.getWidth() - this.maxWidth) / 2;
            }
            case RIGHT: {
                return this.getWidth() - this.maxWidth;
            }
        }
        return 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    private void drawText(GuiGraphics guiGraphics, int scrollOffset) {
        guiGraphics.drawString(this.getFont(), this.getText(), this.getTotalX() - scrollOffset, this.getTotalY(), this.getColor(), this.isDrawShadow());
    }
}

