/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text;

import com.daqem.uilib.gui.component.text.AbstractSingleLineTextComponent;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TruncatedTextComponent
extends AbstractSingleLineTextComponent {
    private int maxWidth;
    private String ellipsis = "...";
    private Component backupText;

    public TruncatedTextComponent(int x, int y, int maxWidth, Component text) {
        super(x, y, text);
        this.maxWidth = maxWidth;
        this.backupText = text;
        this.setTruncatedText();
    }

    public TruncatedTextComponent(int x, int y, int maxWidth, Component text, int color) {
        super(x, y, text, color);
        this.maxWidth = maxWidth;
        this.backupText = text;
        this.setTruncatedText();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        guiGraphics.drawString(this.getFont(), this.getText(), this.getTotalX(), this.getTotalY(), this.getColor(), this.isDrawShadow());
        if (this.isRenderDebugBorder()) {
            guiGraphics.hLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY(), -16776961);
            guiGraphics.vLine(this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.hLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.maxWidth + this.getUnusedSpaceX() - 1, this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.vLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
        }
    }

    protected int getUnusedSpaceX() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.getWidth() - this.maxWidth) / 2;
            }
            case RIGHT: {
                return this.getWidth() - this.maxWidth;
            }
        }
        return 0;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.setTruncatedText();
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
        this.setTruncatedText();
    }

    private void setTruncatedText() {
        String text = this.backupText.getString();
        Font font = this.getFont();
        if (font.width(text) <= this.maxWidth) {
            this.setText(this.backupText);
            return;
        }
        int ellipsisWidth = font.width(this.getEllipsis());
        int availableWidth = this.maxWidth - ellipsisWidth;
        StringBuilder truncated = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (font.width(truncated.toString() + c) > availableWidth) break;
            truncated.append(c);
        }
        truncated.append(this.getEllipsis());
        this.setText((Component)Component.literal((String)truncated.toString()).setStyle(this.getText().getStyle()));
    }
}

