/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text.multiline;

import com.daqem.uilib.gui.component.text.AbstractTextComponent;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMultiLineTextComponent
extends AbstractTextComponent {
    private int maxWidth;
    private List<FormattedCharSequence> lines;

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, Component text) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, Component text, int color) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, Component text, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) {
            this.updateSize();
        }
    }

    public AbstractMultiLineTextComponent(int x, int y, int maxWidth, Component text, int color, boolean preformSizeUpdate) {
        super(x, y, 0, 0, text, color);
        this.maxWidth = maxWidth;
        if (preformSizeUpdate) {
            this.updateSize();
        }
    }

    public List<FormattedCharSequence> getLines() {
        return this.lines;
    }

    public void setLines(List<FormattedCharSequence> lines) {
        this.lines = lines;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        this.updateSize();
    }

    protected void updateSize() {
        this.lines = Language.getInstance().getVisualOrder(AbstractMultiLineTextComponent.findOptimalLines(this.getFont(), this.getText(), this.maxWidth));
        this.setWidth(this.lines.stream().mapToInt(arg_0 -> ((Font)this.getFont()).width(arg_0)).max().orElse(0));
        Objects.requireNonNull(this.getFont());
        this.setHeight(9 * this.getLines().size());
    }

    protected int getUnusedSpaceX() {
        switch (this.getTextAlign()) {
            case CENTER: {
                return (this.getWidth() - this.getMaxWidth()) / 2;
            }
            case RIGHT: {
                return this.getWidth() - this.getMaxWidth();
            }
        }
        return 0;
    }

    protected static List<FormattedText> findOptimalLines(Font font, Component component, int width) {
        StringSplitter stringSplitter = font.getSplitter();
        List optimalLines = null;
        float minDifference = Float.MAX_VALUE;
        float tolerance = 10.0f;
        int offset = 0;
        List lines = stringSplitter.splitLines((FormattedText)component, width - offset, Style.EMPTY);
        float difference = Math.abs(AbstractMultiLineTextComponent.getMaxWidth(stringSplitter, lines) - (float)width);
        if (difference <= tolerance) {
            return lines;
        }
        if (difference < minDifference) {
            optimalLines = lines;
        }
        return optimalLines;
    }

    private static float getMaxWidth(@NotNull StringSplitter stringSplitter, List<FormattedText> formattedTexts) {
        return (float)formattedTexts.stream().mapToDouble(arg_0 -> ((StringSplitter)stringSplitter).stringWidth(arg_0)).max().orElse(0.0);
    }
}

