/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.component.text.multiline;

import com.daqem.uilib.gui.component.text.multiline.AbstractMultiLineTextComponent;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class TruncatedMultiLineTextComponent
extends AbstractMultiLineTextComponent {
    private int maxLines;
    private String ellipsis = "...";

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, Component text) {
        super(x, y, maxWidth, text, false);
        this.maxLines = maxLines;
        this.updateSize();
    }

    public TruncatedMultiLineTextComponent(int x, int y, int maxWidth, int maxLines, Component text, int color) {
        super(x, y, maxWidth, text, color, false);
        this.maxLines = maxLines;
        this.updateSize();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    @Override
    protected void updateSize() {
        this.setLines(Language.getInstance().getVisualOrder(TruncatedMultiLineTextComponent.findOptimalLines(this.getFont(), this.getText(), this.getMaxWidth())));
        if (this.getLines().size() > this.maxLines) {
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>(this.getLines());
            lines.subList(this.maxLines, lines.size()).clear();
            this.setLines(lines);
            int lastIndex = this.getLines().size() - 1;
            if (lastIndex < 0) {
                return;
            }
            FormattedCharSequence lastLine = this.getLines().get(lastIndex);
            StringBuilder builder = new StringBuilder();
            lastLine.accept((index, style, codePoint) -> {
                builder.appendCodePoint(codePoint);
                return true;
            });
            String truncatedLine = builder.toString();
            while (this.getFont().width(truncatedLine + this.ellipsis) > this.getMaxWidth() && !truncatedLine.isEmpty()) {
                truncatedLine = truncatedLine.substring(0, truncatedLine.length() - 1);
            }
            this.getLines().set(lastIndex, Component.literal((String)(truncatedLine + this.ellipsis)).withStyle(Style.EMPTY).getVisualOrderText());
        }
        this.setWidth(this.getLines().stream().mapToInt(arg_0 -> ((Font)this.getFont()).width(arg_0)).max().orElse(0));
        Objects.requireNonNull(this.getFont());
        this.setHeight(9 * this.getLines().size());
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int parentWidth, int parentHeight) {
        for (int i = 0; i < this.getLines().size(); ++i) {
            Font font = this.getFont();
            int n = this.getTotalX();
            int n2 = this.getTotalY();
            Objects.requireNonNull(this.getFont());
            guiGraphics.drawString(font, this.getLines().get(i), n, n2 + i * 9, this.getColor(), this.isDrawShadow());
        }
        if (this.isRenderDebugBorder()) {
            guiGraphics.hLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY(), -16776961);
            guiGraphics.vLine(this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.hLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalX() + this.getMaxWidth() + this.getUnusedSpaceX() - 1, this.getTotalY() + this.getHeight() - 1, -16776961);
            guiGraphics.vLine(this.getTotalX() + this.getUnusedSpaceX(), this.getTotalY(), this.getTotalY() + this.getHeight() - 1, -16776961);
        }
    }
}

