/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.widget;

import com.daqem.uilib.api.IParent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollContainer2DWidget
extends AbstractContainerWidget
implements IWidget,
IParent {
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"widget/scroller_background");
    protected final List<IComponent> components = new ArrayList<IComponent>();
    private final int contentSpacing;
    private double horizontalScrollAmount;
    private boolean scrollingHorizontal;
    private boolean scrollingVertical;

    public ScrollContainer2DWidget(int width, int height, int contentSpacing) {
        super(0, 0, width, height, (Component)Component.empty());
        this.contentSpacing = contentSpacing;
        this.horizontalScrollAmount = 0.0;
    }

    public ScrollContainer2DWidget(int width, int height) {
        this(width, height, 0);
    }

    protected int contentHeight() {
        if (this.components.isEmpty()) {
            return 0;
        }
        return this.components.stream().mapToInt(LayoutElement::getHeight).sum() + this.getContentSpacing() * (this.components.size() - 1);
    }

    protected double scrollRate() {
        return 10.0;
    }

    protected int contentWidth() {
        if (this.components.isEmpty()) {
            return 0;
        }
        return this.components.stream().mapToInt(LayoutElement::getWidth).max().orElse(0);
    }

    protected int maxHorizontalScrollAmount() {
        return Math.max(0, this.contentWidth() - this.width);
    }

    protected boolean horizontalScrollbarVisible() {
        return this.maxHorizontalScrollAmount() > 0;
    }

    protected int scrollerWidth() {
        int adjW = this.width - (this.scrollbarVisible() ? 6 : 0);
        int contentW = this.contentWidth();
        if (contentW <= adjW) {
            return 0;
        }
        return Mth.clamp((int)((int)((float)(adjW * adjW) / (float)contentW)), (int)32, (int)(adjW - 8));
    }

    protected double horizontalScrollRate() {
        return 10.0;
    }

    public double horizontalScrollAmount() {
        return this.horizontalScrollAmount;
    }

    public void setHorizontalScrollAmount(double amount) {
        this.horizontalScrollAmount = Mth.clamp((double)amount, (double)0.0, (double)this.maxHorizontalScrollAmount());
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible) {
            return false;
        }
        boolean handled = false;
        if (scrollY != 0.0) {
            this.setScrollAmount(this.scrollAmount() - scrollY * this.scrollRate());
            handled = true;
        }
        if (scrollX != 0.0) {
            this.setHorizontalScrollAmount(this.horizontalScrollAmount() - scrollX * this.horizontalScrollRate());
            handled = true;
        }
        return handled;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.visible) {
            return false;
        }
        boolean handled = false;
        if (this.isValidClickButton(button)) {
            boolean onVBar;
            boolean onHBar;
            this.scrollingHorizontal = onHBar = this.horizontalScrollbarVisible() && mouseY >= (double)(this.getBottom() - 6) && mouseY < (double)this.getBottom() && mouseX >= (double)this.getX() && mouseX < (double)this.getRight();
            this.scrollingVertical = onVBar = !onHBar && this.scrollbarVisible() && mouseX >= (double)this.scrollBarX() && mouseX < (double)(this.scrollBarX() + 6) && mouseY >= (double)this.getY() && mouseY < (double)this.getBottom();
            if (onHBar || onVBar) {
                handled = true;
            } else {
                Optional optional = this.getChildAt(mouseX, mouseY);
                if (optional.isPresent()) {
                    GuiEventListener guiEventListener = (GuiEventListener)optional.get();
                    if (guiEventListener.mouseClicked(mouseX, mouseY, button)) {
                        this.setFocused(guiEventListener);
                        if (button == 0) {
                            this.setDragging(true);
                        }
                        handled = true;
                    }
                } else {
                    this.onClick(mouseX, mouseY);
                    handled = true;
                }
            }
        }
        return handled;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrollingVertical) {
            if (mouseY < (double)this.getY()) {
                this.setScrollAmount(0.0);
            } else if (mouseY > (double)this.getBottom()) {
                this.setScrollAmount(this.maxScrollAmount());
            } else {
                double d = Math.max(1, this.maxScrollAmount());
                int i = this.scrollerHeight();
                double e = Math.max(1.0, d / (double)(this.height - i));
                this.setScrollAmount(this.scrollAmount() + dragY * e);
            }
            return true;
        }
        if (this.scrollingHorizontal) {
            if (mouseX < (double)this.getX()) {
                this.setHorizontalScrollAmount(0.0);
            } else if (mouseX > (double)this.getRight()) {
                this.setHorizontalScrollAmount(this.maxHorizontalScrollAmount());
            } else {
                double d = Math.max(1, this.maxHorizontalScrollAmount());
                int i = this.scrollerWidth();
                double e = Math.max(1.0, d / (double)(this.width - i));
                this.setHorizontalScrollAmount(this.horizontalScrollAmount() + dragX * e);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public void onRelease(double mouseX, double mouseY) {
        this.scrollingVertical = false;
        this.scrollingHorizontal = false;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean vBar = this.scrollbarVisible();
        boolean hBar = this.horizontalScrollbarVisible();
        int availW = this.width - (vBar ? 6 : 0);
        int availH = this.height - (hBar ? 6 : 0);
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getX() + availW, this.getY() + availH);
        int currentX = this.uilib$getParentX() - this.getX() - (int)this.horizontalScrollAmount();
        int currentY = this.uilib$getParentY() - this.getY() - (int)this.scrollAmount();
        for (int i = 0; i < this.components.size(); ++i) {
            IComponent component = this.components.get(i);
            component.setX(currentX);
            component.setY(currentY);
            component.renderBase(guiGraphics, mouseX, mouseY, partialTick, availW, availH);
            currentY += component.getHeight();
            if (i >= this.components.size() - 1) continue;
            currentY += this.getContentSpacing();
        }
        guiGraphics.disableScissor();
        this.renderScrollbar(guiGraphics);
    }

    protected void renderScrollbar(GuiGraphics guiGraphics) {
        if (this.scrollbarVisible()) {
            int adjH = this.height - (this.horizontalScrollbarVisible() ? 6 : 0);
            int i = this.scrollBarX();
            int j = this.scrollerHeight();
            int k = this.scrollBarY();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_BACKGROUND_SPRITE, i, this.getY(), 6, adjH);
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, i, k, 6, j);
        }
        if (this.horizontalScrollbarVisible()) {
            int adjW = this.width - (this.scrollbarVisible() ? 6 : 0);
            int bottom = this.getBottom();
            int hY = bottom - 6;
            int hX = this.getX();
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_BACKGROUND_SPRITE, hX, hY, adjW, 6);
            int scrollerW = this.scrollerWidth();
            double fracH = this.maxHorizontalScrollAmount() > 0 ? this.horizontalScrollAmount() / (double)this.maxHorizontalScrollAmount() : 0.0;
            int scrollerX = (int)((double)hX + fracH * (double)(adjW - scrollerW));
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, scrollerX, hY, scrollerW, 6);
        }
    }

    protected int scrollerHeight() {
        int adjH = this.height - (this.horizontalScrollbarVisible() ? 6 : 0);
        int contentH = this.contentHeight();
        if (contentH <= adjH) {
            return 0;
        }
        return Mth.clamp((int)((int)((float)(adjH * adjH) / (float)contentH)), (int)32, (int)(adjH - 8));
    }

    protected int scrollBarY() {
        int max = this.maxScrollAmount();
        if (max == 0) {
            return this.getY();
        }
        int adjH = this.height - (this.horizontalScrollbarVisible() ? 6 : 0);
        int h = this.scrollerHeight();
        return (int)(this.scrollAmount() * (double)(adjH - h) / (double)max) + this.getY();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @NotNull
    public ScreenRectangle getBorderForArrowNavigation(ScreenDirection direction) {
        return new ScreenRectangle(this.getX(), this.getY(), this.width, this.contentHeight());
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        super.setFocused(focused);
        if (focused != null && Minecraft.getInstance().getLastInputType().isKeyboard()) {
            ScreenRectangle screenRectangle = this.getRectangle();
            ScreenRectangle screenRectangle2 = focused.getRectangle();
            int i = screenRectangle2.top() - screenRectangle.top();
            int j = screenRectangle2.bottom() - screenRectangle.bottom();
            if (i < 0) {
                this.setScrollAmount(this.scrollAmount() + (double)i - 14.0);
            } else if (j > 0) {
                this.setScrollAmount(this.scrollAmount() + (double)j + 14.0);
            }
        }
    }

    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.getWidgets();
    }

    @NotNull
    public Collection<? extends NarratableEntry> getNarratables() {
        return this.getWidgets();
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        this.components.addAll(components);
    }

    @Override
    public void removeComponent(IComponent component) {
        this.components.remove(component);
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        this.components.removeAll(components);
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    public void clear() {
        this.clearComponents();
        this.clearOnlyWidgets();
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.components.stream().flatMap(component -> component.getAllWidgets().stream()).toList();
    }

    @Override
    public void addWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot add a widget directly to ScrollContainer2DWidget. Add it to a component instead.");
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot add widgets directly to ScrollContainer2DWidget. Add them to a component instead.");
    }

    @Override
    public void removeWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot remove a widget directly from ScrollContainer2DWidget. Remove it from a component instead.");
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot remove widgets directly from ScrollContainer2DWidget. Remove them from a component instead.");
    }

    @Override
    public void clearOnlyWidgets() {
        throw new UnsupportedOperationException("Cannot clear widgets directly from ScrollContainer2DWidget. Clear them from components instead.");
    }

    public int getContentSpacing() {
        return this.contentSpacing;
    }
}

