/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.gui.widget.skilltree;

import com.daqem.uilib.api.IParent;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.api.widget.IWidget;
import com.daqem.uilib.api.widget.skilltree.ISkillTreeWidget;
import com.daqem.uilib.gui.component.skilltree.SkillTreeMovingComponent;
import com.daqem.uilib.gui.widget.ScrollContainer2DWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SkillTreeWidget
extends ScrollContainer2DWidget
implements IWidget,
IParent,
ISkillTreeWidget {
    private boolean hasDragged;
    private double clickStartX;
    private double clickStartY;
    private static final double DRAG_THRESHOLD = 2.0;

    public SkillTreeWidget(int width, int height) {
        super(width, height);
    }

    @Override
    protected int contentHeight() {
        return this.components.isEmpty() ? 0 : ((IComponent)this.components.getFirst()).getHeight();
    }

    @Override
    protected int contentWidth() {
        return this.components.isEmpty() ? 0 : ((IComponent)this.components.getFirst()).getWidth();
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.clear();
        this.components.add(component);
    }

    @Override
    public void addComponents(List<? extends IComponent> components) {
        if (components.size() > 1) {
            throw new IllegalArgumentException("SkillTreeWidget can only hold one component.");
        }
        if (!components.isEmpty()) {
            this.addComponent(components.getFirst());
        }
    }

    @Override
    public void removeComponent(IComponent component) {
        if (!this.components.isEmpty() && this.components.getFirst() == component) {
            this.components.clear();
        }
    }

    @Override
    public void removeComponents(List<? extends IComponent> components) {
        if (!this.components.isEmpty() && components.contains(this.components.getFirst())) {
            this.components.clear();
        }
    }

    @Override
    public void clearComponents() {
        this.components.clear();
    }

    @Override
    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.components.isEmpty()) {
            return;
        }
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
        IComponent component = (IComponent)this.components.getFirst();
        int offsetX = (int)this.horizontalScrollAmount();
        int offsetY = (int)this.scrollAmount();
        component.setX(this.getX() - this.uilib$getParentX() - offsetX);
        component.setY(this.getY() - this.uilib$getParentY() - offsetY);
        component.renderBase(guiGraphics, mouseX, mouseY, partialTick, this.getWidth(), this.getHeight());
        guiGraphics.disableScissor();
    }

    @Override
    protected void renderScrollbar(GuiGraphics guiGraphics) {
    }

    protected boolean scrollbarVisible() {
        return false;
    }

    @Override
    protected boolean horizontalScrollbarVisible() {
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.active || !this.visible) {
            return false;
        }
        if (this.isValidClickButton(button)) {
            this.hasDragged = false;
            this.clickStartX = mouseX;
            this.clickStartY = mouseY;
            this.setDragging(true);
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isValidClickButton(button) && this.isDragging()) {
            double deltaX = Math.abs(mouseX - this.clickStartX);
            double deltaY = Math.abs(mouseY - this.clickStartY);
            if (deltaX > 2.0 || deltaY > 2.0) {
                this.hasDragged = true;
            }
            double newHorizontal = this.horizontalScrollAmount() - dragX;
            this.setHorizontalScrollAmount(newHorizontal);
            double newVertical = this.scrollAmount() - dragY;
            this.setScrollAmount(newVertical);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        if (this.isValidClickButton(button)) {
            this.setDragging(false);
            if (!this.hasDragged) {
                GuiEventListener guiEventListener;
                boolean handled;
                Optional optional = this.getChildAt(mouseX, mouseY);
                if (optional.isPresent() && (handled = (guiEventListener = (GuiEventListener)optional.get()).mouseClicked(mouseX, mouseY, button))) {
                    this.setFocused(guiEventListener);
                    return true;
                }
                this.onClick(mouseX, mouseY);
                return true;
            }
            if (this.getFocused() != null) {
                return this.getFocused().mouseReleased(mouseX, mouseY, button);
            }
        }
        return false;
    }

    @Override
    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    @NotNull
    public ScreenRectangle getBorderForArrowNavigation(ScreenDirection direction) {
        return new ScreenRectangle(this.getX(), this.getY(), this.contentWidth(), this.contentHeight());
    }

    @Override
    public void setFocused(@Nullable GuiEventListener focused) {
        super.setFocused(focused);
        if (focused != null && Minecraft.getInstance().getLastInputType().isKeyboard()) {
            ScreenRectangle screenRectangle = this.getRectangle();
            ScreenRectangle screenRectangle2 = focused.getRectangle();
            int i = screenRectangle2.top() - screenRectangle.top();
            int j = screenRectangle2.bottom() - screenRectangle.bottom();
            if (i < 0) {
                this.setScrollAmount(this.scrollAmount() + (double)i - 14.0);
            } else if (j > 0) {
                this.setScrollAmount(this.scrollAmount() + (double)j + 14.0);
            }
        }
    }

    @Override
    @NotNull
    public List<? extends GuiEventListener> children() {
        return this.components.isEmpty() ? List.of() : ((IComponent)this.components.getFirst()).getAllWidgets();
    }

    @Override
    @NotNull
    public Collection<? extends NarratableEntry> getNarratables() {
        return this.components.isEmpty() ? List.of() : ((IComponent)this.components.getFirst()).getAllWidgets();
    }

    @Override
    public List<IComponent> getComponents() {
        return new ArrayList<IComponent>(this.components);
    }

    @Override
    public void clear() {
        this.clearComponents();
    }

    @Override
    public List<IWidget> getWidgets() {
        return this.components.isEmpty() ? List.of() : ((IComponent)this.components.getFirst()).getAllWidgets();
    }

    @Override
    public void addWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot add a widget directly to SkillTreeWidget. Add it to the component instead.");
    }

    @Override
    public void addWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot add widgets directly to SkillTreeWidget. Add them to the component instead.");
    }

    @Override
    public void removeWidget(IWidget widget) {
        throw new UnsupportedOperationException("Cannot remove a widget directly from SkillTreeWidget. Remove it from the component instead.");
    }

    @Override
    public void removeWidgets(List<? extends IWidget> widgets) {
        throw new UnsupportedOperationException("Cannot remove widgets directly from SkillTreeWidget. Remove them from the component instead.");
    }

    @Override
    public void clearOnlyWidgets() {
        throw new UnsupportedOperationException("Cannot clear widgets directly from SkillTreeWidget. Clear them from the component instead.");
    }

    @Override
    public int getContentSpacing() {
        return 0;
    }

    @Override
    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Object e;
        if (this.isMouseOver(mouseX, mouseY) && !this.components.isEmpty() && (e = this.components.getFirst()) instanceof SkillTreeMovingComponent) {
            SkillTreeMovingComponent skillTreeMovingComponent = (SkillTreeMovingComponent)e;
            skillTreeMovingComponent.renderTooltips(guiGraphics, mouseX, mouseY);
        }
    }
}

