/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.uilib.test;

import com.daqem.uilib.UILib;
import com.daqem.uilib.api.component.IComponent;
import com.daqem.uilib.gui.AbstractScreen;
import com.daqem.uilib.gui.background.DarkenedBackground;
import com.daqem.uilib.gui.widget.ButtonWidget;
import com.daqem.uilib.test.component.TestComponent;
import com.daqem.uilib.test.component.TestScrollWidgetComponent;
import com.daqem.uilib.test.component.TestSkillTreeComponent;
import com.daqem.uilib.test.component.TestTextsComponent;
import com.daqem.uilib.test.component.TestWidgetsComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;

public class TestScreen
extends AbstractScreen {
    private final List<IComponent> components = new ArrayList<IComponent>();
    private int activeComponentIndex = 0;

    public TestScreen() {
        super((Component)UILib.translatable("screen.test.title"));
        DarkenedBackground background = new DarkenedBackground();
        this.setBackground(background);
    }

    @Override
    public void init() {
        TestSkillTreeComponent testComponent0 = new TestSkillTreeComponent();
        TestTextsComponent testComponent1 = new TestTextsComponent(1);
        TestWidgetsComponent testComponent2 = new TestWidgetsComponent(2);
        TestComponent testComponent3 = new TestComponent(3);
        TestScrollWidgetComponent testComponent4 = new TestScrollWidgetComponent(3);
        this.components.clear();
        this.components.add(testComponent0);
        this.components.add(testComponent1);
        this.components.add(testComponent2);
        this.components.add(testComponent3);
        this.components.add(testComponent4);
        testComponent0.center();
        testComponent1.center();
        testComponent2.center();
        testComponent3.center();
        testComponent4.center();
        this.addComponent(this.components.get(this.activeComponentIndex));
        this.addWidget(new ButtonWidget(10, this.height - 30, 50, 20, (Component)UILib.translatable("screen.test.button.previous"), button -> this.previousComponent()));
        this.addWidget(new ButtonWidget(this.width - 60, this.height - 30, 50, 20, (Component)UILib.translatable("screen.test.button.next"), button -> this.nextComponent()));
        super.init();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 263) {
            this.previousComponent();
            return true;
        }
        if (keyCode == 262) {
            this.nextComponent();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void nextComponent() {
        this.removeComponent(this.components.get(this.activeComponentIndex));
        this.activeComponentIndex = (this.activeComponentIndex + 1) % this.components.size();
        this.addComponent(this.components.get(this.activeComponentIndex));
        super.init();
    }

    private void previousComponent() {
        this.removeComponent(this.components.get(this.activeComponentIndex));
        this.activeComponentIndex = (this.activeComponentIndex - 1 + this.components.size()) % this.components.size();
        this.addComponent(this.components.get(this.activeComponentIndex));
        super.init();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

