/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.block.entity;

import com.daqem.irobot.block.entity.IRobotBlockEntities;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.item.BatteryItem;
import com.daqem.irobot.item.data.BatteryDataComponent;
import com.daqem.irobot.item.data.IRobotDataComponents;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RobotStationBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RobotStationBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)IRobotBlockEntities.ROBOT_STATION.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RobotStationBlockEntity station) {
        AABB chargingArea = new AABB(pos);
        List entities = level.getEntitiesOfClass(Entity.class, chargingArea);
        for (Entity entity : entities) {
            if (entity instanceof IRobotEntity) {
                IRobotEntity robot = (IRobotEntity)entity;
                RobotStationBlockEntity.chargeRobot(robot, station);
                continue;
            }
            if (!(entity instanceof ItemEntity)) continue;
            ItemEntity itemEntity = (ItemEntity)entity;
            RobotStationBlockEntity.chargeBatteryItem(itemEntity);
        }
    }

    private static void chargeRobot(IRobotEntity robot, RobotStationBlockEntity station) {
        ItemStack batteryStack = robot.getInventory().getBattery();
        if (!batteryStack.isEmpty() && batteryStack.getItem() instanceof BatteryItem) {
            BatteryDataComponent data = (BatteryDataComponent)batteryStack.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
            if (data != null && data.energy() < data.maxEnergy()) {
                double newEnergy = Math.min(data.energy() + (double)((Integer)IRobotConfig.ROBOT_STATION_CHARGE_RATE.get()).intValue(), data.maxEnergy());
                batteryStack.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(newEnergy));
            } else if (data == null) {
                batteryStack.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)new BatteryDataComponent(0.0, ((BatteryItem)batteryStack.getItem()).getMaxEnergy()));
            }
        }
    }

    private static void chargeBatteryItem(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        Item item = itemStack.getItem();
        if (item instanceof BatteryItem) {
            BatteryItem batteryItem = (BatteryItem)item;
            BatteryDataComponent data = (BatteryDataComponent)itemStack.get((DataComponentType)IRobotDataComponents.BATTERY_DATA.get());
            if (data != null && data.energy() < data.maxEnergy()) {
                double newEnergy = Math.min(data.energy() + (double)((Integer)IRobotConfig.ROBOT_STATION_CHARGE_RATE.get()).intValue(), data.maxEnergy());
                itemStack.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)data.withEnergy(newEnergy));
            } else if (data == null) {
                itemStack.set((DataComponentType)IRobotDataComponents.BATTERY_DATA.get(), (Object)new BatteryDataComponent(0.0, batteryItem.getMaxEnergy()));
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

