/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.renderer;

import com.daqem.irobot.client.config.IRobotClientConfig;
import com.daqem.irobot.item.TaskItem;
import com.daqem.irobot.item.TaskMarkerItem;
import com.daqem.irobot.item.data.IRobotDataComponents;
import com.daqem.irobot.item.data.TaskMarkerDataComponent;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class OutlineRenderer {
    public static void renderOutline(PoseStack poseStack) {
        GlobalPos secondPos;
        if (!((Boolean)IRobotClientConfig.RENDER_TASK_AREA_OUTLINE.get()).booleanValue()) {
            return;
        }
        ItemStack itemStack = OutlineRenderer.getValidTaskMarkerItem();
        if (itemStack == null) {
            return;
        }
        TaskMarkerDataComponent data = OutlineRenderer.getTaskMarkerData(itemStack);
        if (data == null) {
            return;
        }
        GlobalPos firstPos = data.firstPos();
        if (!OutlineRenderer.isValidBox(firstPos, secondPos = data.secondPos())) {
            return;
        }
        OutlineRenderer.renderBoxOutline(poseStack, firstPos, secondPos);
    }

    private static ItemStack getValidTaskMarkerItem() {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer localPlayer = minecraft.player;
        if (localPlayer == null) {
            return null;
        }
        ItemStack mainHand = localPlayer.getMainHandItem();
        if (mainHand.getItem() instanceof TaskMarkerItem || mainHand.getItem() instanceof TaskItem) {
            return mainHand;
        }
        ItemStack offHand = localPlayer.getOffhandItem();
        if (offHand.getItem() instanceof TaskMarkerItem || mainHand.getItem() instanceof TaskItem) {
            return offHand;
        }
        return null;
    }

    private static TaskMarkerDataComponent getTaskMarkerData(ItemStack itemStack) {
        DataComponentType component = (DataComponentType)IRobotDataComponents.TASK_MARKER_DATA.get();
        if (!itemStack.has(component)) {
            return null;
        }
        return (TaskMarkerDataComponent)itemStack.get(component);
    }

    private static boolean isValidBox(GlobalPos firstPos, GlobalPos secondPos) {
        return firstPos != null && !firstPos.pos().equals((Object)BlockPos.ZERO) && secondPos != null && !secondPos.pos().equals((Object)BlockPos.ZERO) && firstPos.dimension().equals(secondPos.dimension());
    }

    private static void renderBoxOutline(PoseStack poseStack, GlobalPos firstPos, GlobalPos secondPos) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || !firstPos.dimension().equals(minecraft.level.dimension())) {
            return;
        }
        AABB box = OutlineRenderer.createBoundingBox(firstPos.pos(), secondPos.pos());
        Vec3 camera = minecraft.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        OutlineBufferSource buffer = minecraft.renderBuffers().outlineBufferSource();
        VertexConsumer consumer = buffer.getBuffer(RenderType.debugQuads());
        float inflate = box.contains(camera) ? -0.0078125f : 0.0078125f;
        box = box.move(camera.scale(-1.0));
        Vector3f minPos = new Vector3f((float)box.minX - inflate, (float)box.minY - inflate, (float)box.minZ - inflate);
        Vector3f maxPos = new Vector3f((float)box.maxX + inflate, (float)box.maxY + inflate, (float)box.maxZ + inflate);
        OutlineRenderer.renderBoxEdges(poseStack, consumer, minPos, maxPos);
        buffer.endOutlineBatch();
        poseStack.popPose();
    }

    public static AABB createBoundingBox(BlockPos firstPos, BlockPos secondPos) {
        double minX = (double)Math.min(firstPos.getX(), secondPos.getX()) + 0.001;
        double minY = (double)Math.min(firstPos.getY(), secondPos.getY()) + 0.001;
        double minZ = (double)Math.min(firstPos.getZ(), secondPos.getZ()) + 0.001;
        double maxX = (double)(Math.max(firstPos.getX(), secondPos.getX()) + 1) - 0.001;
        double maxY = (double)(Math.max(firstPos.getY(), secondPos.getY()) + 1) - 0.001;
        double maxZ = (double)(Math.max(firstPos.getZ(), secondPos.getZ()) + 1) - 0.001;
        return new AABB(new Vec3(minX, minY, minZ), new Vec3(maxX, maxY, maxZ));
    }

    protected static void renderBoxEdges(PoseStack ms, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos) {
        PoseStack.Pose pose = ms.last();
        float lenX = maxPos.x() - minPos.x();
        float lenY = maxPos.y() - minPos.y();
        float lenZ = maxPos.z() - minPos.z();
        class Edge {
            final float x;
            final float y;
            final float z;
            final float len;
            final Direction dir;

            Edge(float x, float y, float z, Direction dir, float len) {
                this.x = x;
                this.y = y;
                this.z = z;
                this.dir = dir;
                this.len = len;
            }
        }
        List<Edge> edges = List.of(new Edge(minPos.x(), minPos.y(), minPos.z(), Direction.EAST, lenX), new Edge(minPos.x(), minPos.y(), minPos.z(), Direction.UP, lenY), new Edge(minPos.x(), minPos.y(), minPos.z(), Direction.SOUTH, lenZ), new Edge(maxPos.x(), minPos.y(), minPos.z(), Direction.UP, lenY), new Edge(maxPos.x(), minPos.y(), minPos.z(), Direction.SOUTH, lenZ), new Edge(minPos.x(), maxPos.y(), minPos.z(), Direction.EAST, lenX), new Edge(minPos.x(), maxPos.y(), minPos.z(), Direction.SOUTH, lenZ), new Edge(minPos.x(), minPos.y(), maxPos.z(), Direction.EAST, lenX), new Edge(minPos.x(), minPos.y(), maxPos.z(), Direction.UP, lenY), new Edge(minPos.x(), maxPos.y(), maxPos.z(), Direction.EAST, lenX), new Edge(maxPos.x(), minPos.y(), maxPos.z(), Direction.UP, lenY), new Edge(maxPos.x(), maxPos.y(), minPos.z(), Direction.SOUTH, lenZ));
        Vector3f origin = new Vector3f();
        for (Edge e : edges) {
            origin.set(e.x, e.y, e.z);
            OutlineRenderer.bufferCuboidLine(pose, consumer, origin, e.dir, e.len);
        }
    }

    public static void bufferCuboidLine(PoseStack.Pose pose, VertexConsumer consumer, Vector3f origin, Direction direction, float length) {
        Vector3f minPos = new Vector3f();
        Vector3f maxPos = new Vector3f();
        float halfWidth = ((Float)IRobotClientConfig.OUTLINE_WIDTH.get()).floatValue() / 2.0f;
        minPos.set(origin.x() - halfWidth, origin.y() - halfWidth, origin.z() - halfWidth);
        maxPos.set(origin.x() + halfWidth, origin.y() + halfWidth, origin.z() + halfWidth);
        switch (direction) {
            case DOWN: {
                minPos.add(0.0f, -length, 0.0f);
                break;
            }
            case UP: {
                maxPos.add(0.0f, length, 0.0f);
                break;
            }
            case NORTH: {
                minPos.add(0.0f, 0.0f, -length);
                break;
            }
            case SOUTH: {
                maxPos.add(0.0f, 0.0f, length);
                break;
            }
            case WEST: {
                minPos.add(-length, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                maxPos.add(length, 0.0f, 0.0f);
            }
        }
        OutlineRenderer.bufferCuboid(pose, consumer, minPos, maxPos);
    }

    public static void bufferCuboid(PoseStack.Pose pose, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos) {
        Matrix4f posMatrix = pose.pose();
        Matrix3f normalMatrix = pose.normal();
        Vector3f[] corners = new Vector3f[]{new Vector3f(minPos.x(), minPos.y(), maxPos.z()), new Vector3f(minPos.x(), minPos.y(), minPos.z()), new Vector3f(maxPos.x(), minPos.y(), minPos.z()), new Vector3f(maxPos.x(), minPos.y(), maxPos.z()), new Vector3f(minPos.x(), maxPos.y(), minPos.z()), new Vector3f(minPos.x(), maxPos.y(), maxPos.z()), new Vector3f(maxPos.x(), maxPos.y(), maxPos.z()), new Vector3f(maxPos.x(), maxPos.y(), minPos.z())};
        Vector4f temp = new Vector4f();
        float[][] worldCorners = new float[corners.length][3];
        for (int i = 0; i < corners.length; ++i) {
            temp.set(corners[i].x(), corners[i].y(), corners[i].z(), 1.0f);
            temp.mul((Matrix4fc)posMatrix);
            worldCorners[i][0] = temp.x();
            worldCorners[i][1] = temp.y();
            worldCorners[i][2] = temp.z();
        }
        int[][] faces = new int[][]{{0, 1, 2, 3}, {4, 5, 6, 7}, {7, 2, 1, 4}, {5, 0, 3, 6}, {4, 1, 0, 5}, {6, 3, 2, 7}};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
        float[][] uvs = new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}};
        Vector3f normalTemp = new Vector3f();
        for (int f = 0; f < faces.length; ++f) {
            normalTemp.set((Vector3fc)normals[f]);
            normalTemp.mul((Matrix3fc)normalMatrix);
            float nx = normalTemp.x();
            float ny = normalTemp.y();
            float nz = normalTemp.z();
            for (int v = 0; v < 4; ++v) {
                int idx = faces[f][v];
                float[] pos = worldCorners[idx];
                float[] uv = uvs[v];
                consumer.addVertex(pos[0], pos[1], pos[2]).setColor(((Integer)IRobotClientConfig.OUTLINE_COLOR_RED.get()).intValue(), ((Integer)IRobotClientConfig.OUTLINE_COLOR_GREEN.get()).intValue(), ((Integer)IRobotClientConfig.OUTLINE_COLOR_BLUE.get()).intValue(), ((Integer)IRobotClientConfig.OUTLINE_COLOR_ALPHA.get()).intValue()).setUv(uv[0], uv[1]).setOverlay(OverlayTexture.NO_OVERLAY).setLight(1).setNormal(nx, ny, nz);
            }
        }
    }
}

