/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.client.renderer.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.client.model.entity.GyroRobotModel;
import com.daqem.irobot.entity.GyroRobotEntity;
import com.daqem.irobot.entity.IRobotEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.renderer.layer.ItemInHandGeoLayer;

public class GyroRobotEntityRenderer<R extends LivingEntityRenderState>
extends GeoEntityRenderer<GyroRobotEntity, R> {
    public GyroRobotEntityRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new GyroRobotModel());
        this.addRenderLayer((GeoRenderLayer)new ItemInHandGeoLayer<GyroRobotEntity, Void, R>(this, (GeoRenderer)this){

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, ItemDisplayContext displayContext, R renderState, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
                poseStack.pushPose();
                poseStack.scale(0.75f, 0.75f, 0.75f);
                super.renderStackForBone(poseStack, bone, stack, displayContext, renderState, bufferSource, packedLight, packedOverlay);
                poseStack.popPose();
            }
        });
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<GyroRobotEntity, Void, R>(this, (GeoRenderer)this, context){
            private final List<ItemArmorGeoLayer.RenderData> BONES = List.of(ItemArmorGeoLayer.RenderData.head((String)"helmet"), ItemArmorGeoLayer.RenderData.body((String)"chestplate"), ItemArmorGeoLayer.RenderData.leftArm((String)"chestplateLeft"), ItemArmorGeoLayer.RenderData.rightArm((String)"chestplateRight"), ItemArmorGeoLayer.RenderData.leftLeg((String)"leggingsLeft"), ItemArmorGeoLayer.RenderData.rightLeg((String)"leggingsRight"), ItemArmorGeoLayer.RenderData.leftFoot((String)"bootsLeft"), ItemArmorGeoLayer.RenderData.rightFoot((String)"bootsRight"));

            protected List<ItemArmorGeoLayer.RenderData> getRelevantBones(R renderState, BakedGeoModel model) {
                return this.BONES;
            }
        });
        this.addRenderLayer(new GeoRenderLayer<GyroRobotEntity, Void, R>(this, (GeoRenderer)this){
            private static final ResourceLocation EYES_TEXTURE = IRobot.getId("textures/entity/gyro_robot_eyes.png");

            public void render(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
                RenderType overlayRenderType = RenderType.entityCutoutNoCull((ResourceLocation)EYES_TEXTURE);
                VertexConsumer overlayBuffer = bufferSource.getBuffer(overlayRenderType);
                this.getRenderer().reRender(renderState, poseStack, bakedModel, bufferSource, overlayRenderType, overlayBuffer, packedLight, packedOverlay, -1);
            }
        });
        this.addRenderLayer(new GeoRenderLayer<GyroRobotEntity, Void, R>(this, (GeoRenderer)this){
            private static final ResourceLocation OVERLAY_TEXTURE = IRobot.getId("textures/entity/gyro_robot_overlay.png");

            public void render(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, int renderColor) {
                int overlayColor = (Integer)((GeoRenderState)renderState).getGeckolibData(IRobotEntity.OVERLAY_COLOR_TICKET);
                if (overlayColor == -1) {
                    overlayColor = 0xFFFFFF;
                }
                RenderType overlayRenderType = RenderType.entityCutoutNoCull((ResourceLocation)OVERLAY_TEXTURE);
                VertexConsumer overlayBuffer = bufferSource.getBuffer(overlayRenderType);
                this.getRenderer().reRender(renderState, poseStack, bakedModel, bufferSource, overlayRenderType, overlayBuffer, packedLight, packedOverlay, overlayColor | 0xFF000000);
            }
        });
    }

    public void addRenderData(GyroRobotEntity animatable, Void relatedObject, R renderState) {
        super.addRenderData((GeoAnimatable)animatable, (Object)relatedObject, renderState);
        ((GeoRenderState)renderState).addGeckolibData(IRobotEntity.OVERLAY_COLOR_TICKET, (Object)animatable.getOverlayColor());
    }

    public int getRenderColor(GyroRobotEntity animatable, Void relatedObject, float partialTick) {
        return animatable.getColor() | 0xFF000000;
    }
}

