/*
 * Decompiled with CFR 0.152.
 */
package com.daqem.irobot.entity;

import com.daqem.irobot.IRobot;
import com.daqem.irobot.config.IRobotConfig;
import com.daqem.irobot.entity.IRobotEntity;
import com.daqem.irobot.item.TaskItem;
import java.util.EnumMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;

public class MiniRobotEntity
extends IRobotEntity {
    public MiniRobotEntity(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return IRobotEntity.createRobotAttributes();
    }

    @Override
    public int getDefaultColor() {
        return 0x707080;
    }

    @Override
    public int getDefaultOverlayColor() {
        return 4253170;
    }

    @Override
    protected InteractionResult handleItemInteraction(ServerPlayer player, ItemStack itemInHand, InteractionHand hand) {
        if (itemInHand.getItem() instanceof TaskItem) {
            ItemStack currentTask = this.inventory.getTask();
            if (currentTask.isEmpty()) {
                this.inventory.setItem(25, itemInHand.split(1));
                return InteractionResult.SUCCESS;
            }
            player.sendSystemMessage((Component)IRobot.translatable("robot.error.task_slot_full").withStyle(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController(), new AnimationController("HoldItem", 5, test -> {
            EnumMap geckolibData = (EnumMap)test.getData(DataTickets.EQUIPMENT_BY_SLOT);
            ItemStack mainHandItem = (ItemStack)geckolibData.get(EquipmentSlot.MAINHAND);
            if (mainHandItem != null && !mainHandItem.isEmpty()) {
                return test.setAndContinue(RawAnimation.begin().thenLoop("misc.holdItem"));
            }
            return PlayState.STOP;
        }), new AnimationController("Mining", 0, state -> {
            if (this.isMining()) {
                return state.setAndContinue(RawAnimation.begin().thenLoop("attack.swing"));
            }
            return PlayState.STOP;
        })});
    }

    @Override
    public int getRechargeThreshold() {
        return (int)(this.getMaxEnergy() * (Double)IRobotConfig.RECHARGE_THRESHOLD_PERCENTAGE.get());
    }
}

